/*
 * Decompiled with CFR 0.152.
 */
package org.kiama.example.picojava.tests;

import org.junit.runner.RunWith;
import org.kiama.example.picojava.AbstractSyntax;
import org.kiama.example.picojava.Parser;
import org.kiama.example.picojava.Parser$class;
import org.kiama.util.ParserUtilities;
import org.kiama.util.RegexParserTests;
import org.kiama.util.RegexParserTests$class;
import org.kiama.util.Tests$FocusTest$;
import org.kiama.util.Tests$class;
import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.PackratParsers;
import scala.util.parsing.combinator.PackratParsers$Head$;
import scala.util.parsing.combinator.PackratParsers$LR$;
import scala.util.parsing.combinator.PackratParsers$MemoEntry$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u001b\tY\u0001+\u0019:tKJ$Vm\u001d;t\u0015\t\u0019A!A\u0003uKN$8O\u0003\u0002\u0006\r\u0005A\u0001/[2pU\u00064\u0018M\u0003\u0002\b\u0011\u00059Q\r_1na2,'BA\u0005\u000b\u0003\u0015Y\u0017.Y7b\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f-i\u0001\u0003CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!A\u0002)beN,'\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005!Q\u000f^5m\u0013\tyBD\u0001\tSK\u001e,\u0007\u0010U1sg\u0016\u0014H+Z:ugB\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\tY1kY1mC>\u0013'.Z2u\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\u0001\u000b\u0003\u0001YQ*\u0004CA\u00173\u001b\u0005q#BA\u00181\u0003\u0019\u0011XO\u001c8fe*\u0011\u0011GC\u0001\u0006UVt\u0017\u000e^\u0005\u0003g9\u0012qAU;o/&$\b.A\u0003wC2,XmI\u00017!\t94(D\u00019\u0015\t\t\u0014H\u0003\u0002;\u0015\u0005I1oY1mCR,7\u000f^\u0005\u0003ya\u00121BS+oSR\u0014VO\u001c8fe\u0002")
public class ParserTests
implements Parser,
RegexParserTests,
ScalaObject {
    private final Engine org$scalatest$FunSuite$$engine;
    private final Parsers.Parser<AbstractSyntax.Program> program;
    private final PackratParsers.PackratParser<AbstractSyntax.Block> block;
    private final Parsers.Parser<AbstractSyntax.BlockStmt> block_stmt;
    private final Parsers.Parser<AbstractSyntax.ClassDecl> class_decl;
    private final Parsers.Parser<AbstractSyntax.Use> xtends;
    private final Parsers.Parser<AbstractSyntax.VarDecl> var_decl;
    private final PackratParsers.PackratParser<AbstractSyntax.Stmt> stmt;
    private final Parsers.Parser<AbstractSyntax.AssignStmt> assign_stmt;
    private final Parsers.Parser<AbstractSyntax.WhileStmt> while_stmt;
    private final Parsers.Parser<AbstractSyntax.Exp> exp;
    private final Parsers.Parser<AbstractSyntax.Access> posname;
    private final PackratParsers.PackratParser<AbstractSyntax.Access> name;
    private final Parsers.Parser<AbstractSyntax.BooleanLiteral> boolean_literal;
    private final Regex IDENTIFIER;
    private final Regex whiteSpace;
    private final PackratParsers.PackratParser<Object> constrainedInt;
    private Parsers.NoSuccess lastNoSuccess;
    private volatile Tests$FocusTest$ FocusTest$module;
    public volatile int bitmap$0;
    private volatile PackratParsers$MemoEntry$ scala$util$parsing$combinator$PackratParsers$$MemoEntry$module;
    private volatile PackratParsers$LR$ scala$util$parsing$combinator$PackratParsers$$LR$module;
    private volatile PackratParsers$Head$ scala$util$parsing$combinator$PackratParsers$$Head$module;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;

    public ParserTests() {
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        PackratParsers.class.$init$((PackratParsers)this);
        ParserUtilities.class.$init$((ParserUtilities)this);
        Parser$class.$init$(this);
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Tests$class.$init$(this);
        RegexParserTests$class.$init$(this);
        this.test("parse identifier: single letter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("a", this.$outer.regex(this.$outer.IDENTIFIER()), "a");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse identifier: multiple letter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("ab", this.$outer.regex(this.$outer.IDENTIFIER()), "ab");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse identifier: letter and digit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("a1", this.$outer.regex(this.$outer.IDENTIFIER()), "a1");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse identifier: mixed letter and digit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("a1b", this.$outer.regex(this.$outer.IDENTIFIER()), "a1b");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse identifier: multiple mixed letter and digit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("a1b1", this.$outer.regex(this.$outer.IDENTIFIER()), "a1b1");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse comments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.expect(this.$outer.whiteSpace().replaceFirstIn((CharSequence)"// !@#$%^&*abc\n", ""), "");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate errors for invalid tokens: leading underscore", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("_a", this.$outer.regex(this.$outer.IDENTIFIER()), 1, 1, "string matching regex `[a-zA-Z][a-zA-Z0-9]*' expected but `_' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate errors for invalid tokens: digit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("1", this.$outer.regex(this.$outer.IDENTIFIER()), 1, 1, "string matching regex `[a-zA-Z][a-zA-Z0-9]*' expected but `1' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate errors for invalid tokens: leading digit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("1a", this.$outer.regex(this.$outer.IDENTIFIER()), 1, 1, "string matching regex `[a-zA-Z][a-zA-Z0-9]*' expected but `1' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate errors for invalid tokens: C-style comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("/* abc */", this.$outer.regex(this.$outer.whiteSpace()), 1, 1, "string matching regex `(\\s|(//.*\\n))+' expected but `/' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an empty block", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{}", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate a parse error for an empty program", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("", this.$outer.program(), 1, 1, "`{' expected but end of source found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate a parse error for a semi-colon only program", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError(";", this.$outer.program(), 1, 1, "`{' expected but `;' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an empty class declaration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ class A { } }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdnUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an empty class declaration with an extends clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ class A extends B { } }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdnUse>)new Some((Object)new AbstractSyntax.Use("B")), new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate a parse error for a class declaration with a qualified extends clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("{ class A extends A.B { } }", this.$outer.program(), 1, 20, "`{' expected but `.' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a nested class", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ class A { class B { } } }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdnUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("B", (Option<AbstractSyntax.IdnUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))}))))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a variable declaration with a simple type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ A a; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.VarDecl[]{new AbstractSyntax.VarDecl(new AbstractSyntax.Use("A"), "a")})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a variable declaration with a qualified type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ A.B.C a; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.VarDecl[]{new AbstractSyntax.VarDecl(new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("A"), new AbstractSyntax.Use("B")), new AbstractSyntax.Use("C")), "a")})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate an error for a qualified variable declaration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("{ A.B.C a.b; }", this.$outer.program(), 1, 10, "`;' expected but `.' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a simple assignment statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ a = b; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b"))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an assignment statement with a qualified left-hand side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ a.b.c = b; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b")), new AbstractSyntax.Use("c")), new AbstractSyntax.Use("b"))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an assignment statement with a qualified right-hand side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ a = b.c.d; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("b"), new AbstractSyntax.Use("c")), new AbstractSyntax.Use("d")))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a while statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ while ( a ) a = b; }", this.$outer.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractSyntax.WhileStmt[]{new AbstractSyntax.WhileStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b")))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generate an error for a while statement with a block body", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("{ while ( a ) { a = b; } }", this.$outer.program(), 1, 15, "`while' expected but `{' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

