package json.java.phase.typeHandler;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletException;

import json.java.application.AjaxContext;
import json.java.exception.PhaseException;
import json.java.http.MutableRequest;
import json.java.http.MutableResponse;
import json.java.types.Page;

public class PageTypeHandleImpl extends TypeHandlerImpl {

	@Override
	public void returnHandler(AjaxContext context, Object methodReturn) throws PhaseException {
		Page page = (Page) methodReturn;
		
		MutableRequest request = context.getRequest();
		MutableResponse response = context.getResponse();
		
		Iterator<String> it = page.values().keySet().iterator();
		while(it.hasNext()) {
			String key = it.next();
			request.setAttribute(key, page.values().get(key));
		}
		
		try {
			request.getRequestDispatcher(page.getPath()).forward(request, response);
		} catch (ServletException e) {
			throw new PhaseException(e);
		} catch (IOException e) {
			throw new PhaseException(e);
		}
	}
	
}