package json.java.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import json.java.application.AjaxApplication;
import json.java.application.AjaxContext;
import json.java.exception.AjaxException;
import json.java.http.AjaxRequest;
import json.java.http.AjaxRequestInfo;
import json.java.http.AjaxResponse;
import json.java.phase.PhaseContainer;

public class ParserServlet extends HttpServlet {
	private static final long serialVersionUID = 7001522925173682103L;

	@Override
	public void init(ServletConfig config) throws ServletException {
		try {
			AjaxApplication.getInstance().init(config);
			super.init(config);
		} catch (AjaxException e) {
			throw new ServletException(e.getMessage(), e);
		}
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		AjaxRequest ajaxRequest = new AjaxRequest(request);
		AjaxResponse ajaxResponse = new AjaxResponse(response);
		
		AjaxRequestInfo requestInfo = new AjaxRequestInfo(this.getServletContext(), ajaxRequest, ajaxResponse);
		AjaxContext context = new AjaxContext(requestInfo);
		
		try {
			new PhaseContainer(context).selectPhase();
		} catch (AjaxException e) {
			throw new ServletException(e);
		}
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		AjaxRequest ajaxRequest = new AjaxRequest(request);
		AjaxResponse ajaxResponse = new AjaxResponse(response);
		
		AjaxRequestInfo requestInfo = new AjaxRequestInfo(this.getServletContext(), ajaxRequest, ajaxResponse);
		AjaxContext context = new AjaxContext(requestInfo);
		
		try {
			new PhaseContainer(context).selectPhase();
		} catch (AjaxException e) {
			throw new ServletException(e);
		}
	}
}