/*
 * Decompiled with CFR 0.152.
 */
package json.java.application;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import json.java.annotation.AjaxController;
import json.java.exception.AjaxException;

public class AjaxApplication {
    private static AjaxApplication instance;
    private static final String PACKAGE_PARAM_INIT = "scanPackages";
    public static final Map<String, Class<?>> ANNOTATED_CLASSES;

    private AjaxApplication() {
    }

    public static synchronized AjaxApplication getInstance() {
        if (instance == null) {
            instance = new AjaxApplication();
        }
        return instance;
    }

    public void init(ServletConfig config) throws AjaxException {
        if (config == null) {
            throw new AjaxException("config is null!");
        }
        String[] scanAjaxBeanPackagesValue = config.getInitParameter(PACKAGE_PARAM_INIT).split(",");
        if (scanAjaxBeanPackagesValue != null && !"".equals(scanAjaxBeanPackagesValue)) {
            for (String pkg : scanAjaxBeanPackagesValue) {
                try {
                    this.getAnnotatedClasses(config.getServletContext(), pkg.trim());
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void getAnnotatedClasses(ServletContext ctx, String basePackage) throws ClassNotFoundException, MalformedURLException {
        String webInfClassesDir = ctx.getRealPath("/WEB-INF/classes");
        String packageName = "/" + basePackage.replaceAll("\\.", "/");
        String resourcesPath = webInfClassesDir + packageName;
        File root = new File(resourcesPath);
        String path = root.getPath().replaceAll("%20", " ");
        List<File> files = this.listFileClasses(new File(path));
        for (File file : files) {
            String className = file.getName().replaceAll(".class$", "");
            Class<?> classe = Class.forName(basePackage + "." + className);
            if (!classe.isAnnotationPresent(AjaxController.class)) continue;
            AjaxController ajaxController = classe.getAnnotation(AjaxController.class);
            ANNOTATED_CLASSES.put(ajaxController.name(), classe);
        }
    }

    private List<File> listFileClasses(File file) {
        File[] sub;
        ArrayList<File> arquivos = new ArrayList<File>();
        for (File f : sub = file.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".class")) continue;
            arquivos.add(f);
        }
        return arquivos;
    }

    static {
        ANNOTATED_CLASSES = new HashMap();
    }
}

