/*
 * Decompiled with CFR 0.152.
 */
package json.java.phase;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import json.java.application.AjaxContext;
import json.java.exception.LoadResourceException;
import json.java.http.MutableRequest;
import json.java.http.MutableResponse;
import json.java.phase.Phase;
import json.java.phase.PhaseContainer;
import json.java.servlet.ParserServlet;

public class LoadResourcePhase
extends PhaseContainer
implements Phase {
    private static final Map<String, String> AVAILABLE_RESOURCES = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Loader", "/script/loader-min.js");
            this.put("LoaderDebug", "/script/loader.js");
        }
    };

    public LoadResourcePhase(AjaxContext context) {
        super(context);
    }

    @Override
    public void start() throws LoadResourceException {
        try {
            MutableRequest request = this.context.getRequest();
            MutableResponse response = this.context.getResponse();
            Matcher matcher = PATTERN_ENGINE.matcher(request.getRequestURI());
            if (matcher.find()) {
                String resourceName = matcher.group(2).trim();
                InputStream is = ParserServlet.class.getResourceAsStream(AVAILABLE_RESOURCES.get(resourceName));
                if (is == null) {
                    throw new LoadResourceException("Resource \"" + resourceName + "\" not found!");
                }
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                response.getOutputStream().write(bytes);
            }
        }
        catch (IOException e) {
            throw new LoadResourceException(e);
        }
    }
}

