package com.googlecode.lucastody.javatojson.application;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import com.googlecode.lucastody.javatojson.annotation.AjaxController;
import com.googlecode.lucastody.javatojson.exception.AjaxException;

public class AjaxApplication {
	private static AjaxApplication instance;
	private static final String PACKAGE_PARAM_INIT = "scanPackages";
	public static final Map<String, Class<?>> ANNOTATED_CLASSES = new HashMap<String, Class<?>>();
	
	private AjaxApplication() {
		
	}
	
	public static synchronized AjaxApplication getInstance() {
		if(instance == null) {
			instance = new AjaxApplication();
		}
		
		return instance;
	}
	
	public void init(ServletConfig config) throws AjaxException {
		if(config == null) {
			throw new AjaxException("config is null!");
		}
		
		String[] scanAjaxBeanPackagesValue = config.getInitParameter(PACKAGE_PARAM_INIT).split(",");
		
		if(scanAjaxBeanPackagesValue != null && !"".equals(scanAjaxBeanPackagesValue)) {
			for(String pkg : scanAjaxBeanPackagesValue) {
				try {
					getAnnotatedClasses(config.getServletContext(), pkg.trim());
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				} catch (MalformedURLException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	private void getAnnotatedClasses(ServletContext ctx, String basePackage) throws ClassNotFoundException, MalformedURLException {
		String webInfClassesDir = ctx.getRealPath("/WEB-INF/classes");
		String packageName = "/" + basePackage.replaceAll("\\.", "/");
		String resourcesPath = webInfClassesDir + packageName;
		
		File root = new File(resourcesPath);
		
		String path = root.getPath().replaceAll("%20", " ");
		List<File> files = listFileClasses(new File(path));
		
		for (File file : files) {
			String className = file.getName().replaceAll(".class$", "");
			
			Class<?> classe = Class.forName(basePackage + "." + className);
		    if(classe.isAnnotationPresent(AjaxController.class)) {
		    	AjaxController ajaxController = classe.getAnnotation(AjaxController.class);
		    	ANNOTATED_CLASSES.put(ajaxController.name(), classe);
		    }
		}
	}
	
	private List<File> listFileClasses(File file) {
		List<File> arquivos = new ArrayList<File>();
		
		File[] sub = file.listFiles();
		
		for (File f : sub) {
			if (f.isFile()) {
				if(f.getName().endsWith(".class")) {
					arquivos.add(f);
				}
			}
		}
		
		return arquivos;
	}
	
//	private List<File> listFileClasses(File file) {
//		List<File> arquivos = new ArrayList<File>();
//		
//		if (file.isDirectory()) {
//			File[] sub = file.listFiles();
//			for (File f : sub) {
//				if (f.isDirectory()) {
//					arquivos.addAll(listFileClasses(f));
//				} else if(f.getName().endsWith(".class")) {
//					arquivos.add(f);
//				}
//			}
//		}
//		
//		return arquivos;
//	}
}