package com.googlecode.lucastody.javatojson.application;

import javax.servlet.ServletContext;

import com.googlecode.lucastody.javatojson.http.AjaxRequestInfo;
import com.googlecode.lucastody.javatojson.http.MutableRequest;
import com.googlecode.lucastody.javatojson.http.MutableResponse;

public final class AjaxContext {
	private static ThreadLocal<AjaxRequestInfo> requests = new ThreadLocal<AjaxRequestInfo>();
	private static AjaxContext instance;
	
	private AjaxContext() {
		
	}
	
	public synchronized static AjaxContext getInstance() {
		if(instance == null) {
			instance = new AjaxContext();
		}
		
		return instance;
	}
	
	public AjaxContext(AjaxRequestInfo requestInfo) {
		if(requestInfo == null) {
			throw new IllegalArgumentException("Request info cannot be null.");
		}
		
		requests.set(requestInfo);
	}

	private AjaxRequestInfo getContext() {
		return requests.get();
	}
	
	public ServletContext getServletContext() {
		return getContext().getServletContext();
	}
	
	public MutableRequest getRequest() {
		return getContext().getRequest();
	}
	
	public MutableResponse getResponse() {
		return getContext().getResponse();
	}
	
}