package com.googlecode.lucastody.javatojson.phase;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

import com.googlecode.lucastody.javatojson.application.AjaxContext;
import com.googlecode.lucastody.javatojson.exception.LoadResourceException;
import com.googlecode.lucastody.javatojson.http.MutableRequest;
import com.googlecode.lucastody.javatojson.http.MutableResponse;
import com.googlecode.lucastody.javatojson.servlet.ParserServlet;

public class LoadResourcePhase extends PhaseContainer implements Phase {
	
	private static final Map<String, String> AVAILABLE_RESOURCES = new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
	{
		put("Loader", "/script/loader-min.js");
		put("LoaderDebug", "/script/loader.js");
	}};

	public LoadResourcePhase(AjaxContext context) {
		super(context);
	}

	@Override
	public void start() throws LoadResourceException {
		try {
			MutableRequest request = context.getRequest();
			MutableResponse response = context.getResponse();
			
			Matcher matcher = PATTERN_ENGINE.matcher(request.getRequestURI());
			
			if(matcher.find()) {
				String resourceName = matcher.group(2).trim();
				InputStream is = ParserServlet.class.getResourceAsStream(AVAILABLE_RESOURCES.get(resourceName));
				
				if(is == null) {
					throw new LoadResourceException("Resource \""+ resourceName +"\" not found!");
				}
				
				byte[] bytes = new byte[is.available()];
				is.read(bytes);
				
				response.getOutputStream().write(bytes);
			}
		} catch (IOException e) {
			throw new LoadResourceException(e);
		}
	}
}