package com.googlecode.lucastody.javatojson.phase.typeHandler;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import com.googlecode.lucastody.javatojson.application.AjaxContext;
import com.googlecode.lucastody.javatojson.exception.PhaseException;
import com.googlecode.lucastody.javatojson.http.MutableResponse;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.PropertyFilter;

public class DefaultTypeHandleImpl extends TypeHandlerImpl {

	@Override
	public void returnHandler(AjaxContext context, Object methodReturn) throws PhaseException {
		MutableResponse response = context.getResponse();
		Class<?> returnType = methodReturn.getClass();
		
		JsonConfig jsonConfig = new JsonConfig();
		jsonConfig.setCycleDetectionStrategy(new CycleDetectionStrategy() {
			public JSONObject handleRepeatedReferenceAsObject(Object arg0) {
				return new JSONObject(true);
			}
			
			public JSONArray handleRepeatedReferenceAsArray(Object arg0) {
				return IGNORE_PROPERTY_ARR;
			}
		});
		jsonConfig.setJsonPropertyFilter(new PropertyFilter() {
			public boolean apply(Object arg0, String arg1, Object arg2) {
				return false;
			}
		});
		
		if(methodReturn != null) {
			Object retorno = null;
			if(returnType == List.class || returnType == ArrayList.class || returnType == Set.class || returnType == Collection.class) {
				retorno = JSONArray.fromObject(methodReturn, jsonConfig);
			} else {
				if(returnType == String.class) {
					retorno = (String) methodReturn;
				} else if(returnType == Character.class || returnType == Character.TYPE) {
					retorno = new Character(methodReturn.toString().charAt(0));
				} else if(returnType == Long.class || returnType == Long.TYPE) {
					retorno = new Long(methodReturn.toString());
				} else if(returnType == Integer.class || returnType == Integer.TYPE) {
					retorno = new Integer(methodReturn.toString());
				} else if(returnType == Short.class || returnType == Short.TYPE) {
					retorno = new Short(methodReturn.toString());
				} else if(returnType == BigDecimal.class) {
					retorno = new BigDecimal(methodReturn.toString());
				} else if(returnType == Double.class || returnType == Double.TYPE) {
					retorno = new Double(methodReturn.toString());
				} else if(returnType == Float.class || returnType == Float.TYPE) {
					retorno = new Float(methodReturn.toString());
				} else if(returnType == Boolean.class || returnType == Boolean.TYPE) {
					retorno = new Boolean(methodReturn.toString());
				} else if(returnType.isEnum()) {
					retorno = methodReturn.toString();
				} else if(returnType == Date.class) {
					retorno = new Long(((Date) methodReturn).getTime());
				} else {
					retorno = JSONObject.fromObject(methodReturn, jsonConfig);
				}
			}
			
			try {
				response.getOutputStream().write(retorno.toString().getBytes(Charset.forName("UTF-8")));
			} catch (IOException e) {
				throw new PhaseException(e);
			}
		}
	}
}