package com.googlecode.lucastody.javatojson.phase.typeHandler;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletException;

import com.googlecode.lucastody.javatojson.application.AjaxContext;
import com.googlecode.lucastody.javatojson.exception.PhaseException;
import com.googlecode.lucastody.javatojson.http.MutableRequest;
import com.googlecode.lucastody.javatojson.http.MutableResponse;
import com.googlecode.lucastody.javatojson.types.Page;

public class PageTypeHandleImpl extends TypeHandlerImpl {

	@Override
	public void returnHandler(AjaxContext context, Object methodReturn) throws PhaseException {
		Page page = (Page) methodReturn;
		
		MutableRequest request = context.getRequest();
		MutableResponse response = context.getResponse();
		
		Iterator<String> it = page.values().keySet().iterator();
		while(it.hasNext()) {
			String key = it.next();
			request.setAttribute(key, page.values().get(key));
		}
		
		try {
			request.getRequestDispatcher(page.getPath()).forward(request, response);
		} catch (ServletException e) {
			throw new PhaseException(e);
		} catch (IOException e) {
			throw new PhaseException(e);
		}
	}
	
}