package com.googlecode.lucastody.javatojson.types;

import java.util.HashMap;
import java.util.Map;

public class Page extends AjaxType {
	private String path;
	private Map<String, Object> values = new HashMap<String, Object>();
	
	public Page(String path) {
		this.path = path;
	}
	
	public String getPath() {
		return path;
	}
	
	public Map<String, Object> values() {
		return values;
	}

	public void addValue(String key, Object value) {
		values.put(key, value);
	}
	
	public void removeValue(String key) {
		values.remove(key);
	}

	@Override
	public String toString() {
		return path;
	}
}