/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lucastody.javatojson.application;

import com.googlecode.lucastody.javatojson.http.AjaxRequestInfo;
import com.googlecode.lucastody.javatojson.http.MutableRequest;
import com.googlecode.lucastody.javatojson.http.MutableResponse;
import javax.servlet.ServletContext;

public final class AjaxContext {
    private static ThreadLocal<AjaxRequestInfo> requests = new ThreadLocal();
    private static AjaxContext instance;

    private AjaxContext() {
    }

    public static synchronized AjaxContext getInstance() {
        if (instance == null) {
            instance = new AjaxContext();
        }
        return instance;
    }

    public AjaxContext(AjaxRequestInfo requestInfo) {
        if (requestInfo == null) {
            throw new IllegalArgumentException("Request info cannot be null.");
        }
        requests.set(requestInfo);
    }

    private AjaxRequestInfo getContext() {
        return requests.get();
    }

    public ServletContext getServletContext() {
        return this.getContext().getServletContext();
    }

    public MutableRequest getRequest() {
        return this.getContext().getRequest();
    }

    public MutableResponse getResponse() {
        return this.getContext().getResponse();
    }
}

