/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lucastody.javatojson.phase;

import com.googlecode.lucastody.javatojson.annotation.AjaxInterceptor;
import com.googlecode.lucastody.javatojson.application.AjaxApplication;
import com.googlecode.lucastody.javatojson.application.AjaxContext;
import com.googlecode.lucastody.javatojson.exception.AjaxException;
import com.googlecode.lucastody.javatojson.exception.AjaxInterceptorException;
import com.googlecode.lucastody.javatojson.exception.CallUserMethodException;
import com.googlecode.lucastody.javatojson.exception.ExecuteException;
import com.googlecode.lucastody.javatojson.http.MutableRequest;
import com.googlecode.lucastody.javatojson.http.MutableResponse;
import com.googlecode.lucastody.javatojson.interceptor.Interceptor;
import com.googlecode.lucastody.javatojson.phase.Phase;
import com.googlecode.lucastody.javatojson.phase.PhaseContainer;
import com.googlecode.lucastody.javatojson.phase.typeHandler.TypeHandlerImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ExecutePhase
extends PhaseContainer
implements Phase {
    public ExecutePhase(AjaxContext context) {
        super(context);
    }

    @Override
    public void start() throws ExecuteException {
        MutableRequest request = this.context.getRequest();
        MutableResponse response = this.context.getResponse();
        try {
            String beanName = request.getParameter("beanName");
            String methodName = request.getParameter("methodName");
            String parametersTypes = request.getParameter("parametersTypes");
            String arguments = request.getParameter("arguments");
            if (beanName == null || methodName == null || parametersTypes == null || arguments == null) {
                throw new AjaxException("Invalid request parameters.");
            }
            JSONArray arrayParametersTypes = JSONArray.fromObject((Object)parametersTypes);
            List parametersTypesList = (List)JSONArray.toCollection((JSONArray)arrayParametersTypes);
            Class<?>[] typesClassList = this.convertParametersTypes(parametersTypesList);
            Class<?> beanClass = AjaxApplication.ANNOTATED_CLASSES.get(beanName);
            Object beanObject = beanClass.newInstance();
            Method method = beanObject.getClass().getDeclaredMethod(methodName, typesClassList);
            Class<?> returnType = method.getReturnType();
            JSONArray arrayArguments = JSONArray.fromObject((Object)arguments);
            List argumentsList = (List)JSONArray.toCollection((JSONArray)arrayArguments);
            Object[] objectsArgumentsList = this.convertToArrayObjects(argumentsList, typesClassList, method);
            Interceptor methodInterceptor = null;
            if (method.isAnnotationPresent(AjaxInterceptor.class)) {
                AjaxInterceptor tmp = method.getAnnotation(AjaxInterceptor.class);
                methodInterceptor = tmp.value().newInstance();
            }
            if (methodInterceptor != null) {
                methodInterceptor.beforeHandler(this.context, beanObject, objectsArgumentsList);
            }
            Object methodReturn = this.callMethod(beanObject, method, objectsArgumentsList, methodInterceptor);
            if (returnType != Void.TYPE && methodReturn != null) {
                TypeHandlerImpl handleReturn = TypeHandlerImpl.getHandler(returnType);
                handleReturn.returnHandler(this.context, methodReturn);
            }
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (SecurityException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (NoSuchMethodException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            throw new ExecuteException(cause);
        }
        catch (CallUserMethodException e) {
            try {
                response.setStatus(500);
                Throwable cause = e.getCause();
                response.getOutputStream().write(JSONObject.fromObject((Object)cause).toString().getBytes());
            }
            catch (IOException e1) {
                throw new ExecuteException(e1);
            }
        }
        catch (AjaxInterceptorException e) {
            try {
                response.setStatus(500);
                Throwable cause = e.getCause();
                response.getOutputStream().write(JSONObject.fromObject((Object)cause).toString().getBytes());
            }
            catch (IOException e1) {
                throw new ExecuteException(e1);
            }
        }
    }

    private Object callMethod(Object beanObject, Method method, Object[] objectsArgumentsList, Interceptor methodInterceptor) throws CallUserMethodException, AjaxInterceptorException {
        Object methodReturn = null;
        try {
            Object object = methodReturn = method.invoke(beanObject, objectsArgumentsList);
            return object;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new CallUserMethodException(cause);
        }
        finally {
            if (methodInterceptor != null) {
                try {
                    methodInterceptor.afterHandler(this.context, beanObject, objectsArgumentsList, methodReturn);
                }
                catch (RuntimeException e1) {
                    Throwable cause = e1.getCause();
                    throw new AjaxInterceptorException(cause);
                }
            }
        }
    }

    private Class<?>[] convertParametersTypes(List<?> types) throws ClassNotFoundException {
        Class[] clazzTypes = new Class[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            clazzTypes[i] = "char".equalsIgnoreCase(types.get(i).toString()) ? Character.TYPE : ("long".equalsIgnoreCase(types.get(i).toString()) ? Long.TYPE : ("int".equalsIgnoreCase(types.get(i).toString()) ? Integer.TYPE : ("short".equalsIgnoreCase(types.get(i).toString()) ? Short.TYPE : ("double".equalsIgnoreCase(types.get(i).toString()) ? Double.TYPE : ("float".equalsIgnoreCase(types.get(i).toString()) ? Float.TYPE : ("boolean".equalsIgnoreCase(types.get(i).toString()) ? Boolean.TYPE : Class.forName(types.get(i).toString())))))));
        }
        return clazzTypes;
    }

    private Object[] convertToArrayObjects(List<?> arrayArgs, Class<?>[] types, Method method) {
        Object[] arguments = new Object[arrayArgs.size()];
        for (int i = 0; i < arrayArgs.size(); ++i) {
            arguments[i] = this.castObject(arrayArgs.get(i), types[i], method, i);
        }
        return arguments;
    }

    private Object castObject(Object obj, Class<?> type, Method method, Integer index) {
        if (type == List.class || type == ArrayList.class || type == Collection.class) {
            Class<?> tmp = this.recuperaTipoParametrizado(method, index);
            return JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)obj), tmp);
        }
        if (type == String.class) {
            return (String)obj;
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Character.class && type != Character.TYPE)) {
            return new Character(obj.toString().charAt(0));
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Long.class && type != Long.TYPE)) {
            return new Long(obj.toString());
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Integer.class && type != Integer.TYPE)) {
            return new Integer(obj.toString());
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Short.class && type != Short.TYPE)) {
            return new Short(obj.toString());
        }
        if (!ExecutePhase.isEmpty(obj).booleanValue() && type == BigDecimal.class) {
            return new BigDecimal(obj.toString());
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Double.class && type != Double.TYPE)) {
            return new Double(obj.toString());
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Float.class && type != Float.TYPE)) {
            return new Float(obj.toString());
        }
        if (!(ExecutePhase.isEmpty(obj).booleanValue() || type != Boolean.class && type != Boolean.TYPE)) {
            return new Boolean(obj.toString());
        }
        if (!ExecutePhase.isEmpty(obj).booleanValue() && type == Date.class) {
            return new Date(Long.parseLong(obj.toString()));
        }
        if (!ExecutePhase.isEmpty(obj).booleanValue() && type.isEnum()) {
            return Enum.valueOf(type, obj.toString());
        }
        if (!ExecutePhase.isEmpty(obj).booleanValue()) {
            return JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)obj), type);
        }
        return null;
    }

    public Class<?> recuperaTipoParametrizado(Method method, int index) {
        Class tmp = null;
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes[index] instanceof ParameterizedType) {
            Type[] parameterArgTypes;
            ParameterizedType aType = (ParameterizedType)genericParameterTypes[index];
            for (Type parameterArgType : parameterArgTypes = aType.getActualTypeArguments()) {
                Class parameterArgClass;
                tmp = parameterArgClass = (Class)parameterArgType;
            }
        }
        return tmp;
    }

    public static Boolean isEmpty(Object obj) {
        return obj == null || "".equals(obj.toString());
    }
}

