/**
 * StringBuffer para concatenaco de Strings
 */
function StringBuffer() {
	this.buffer = [];
};
StringBuffer.prototype.append = function append(string) {
	this.buffer.push(string);
	return this;
};
StringBuffer.prototype.toString = function toString() {
	return this.buffer.join("");
};

/**
 * Instncia principal
 */
var Loader;

/**
 * LoaderConfig
 */
var LoaderConfig = function(jQueryNoConflict) {
	this.jQuery = jQueryNoConflict;
};
LoaderConfig.prototype = {
	defaults: {
		async: true,
		charset: 'ISO-8859-1'
	},
	
	/** Cria uma nova instncia para evitar conflitos **/
	noConflict: function() {
		return new LoaderConfig(this.jQuery);
	},
	
	/** Obtm o objeto ajax */
	getXMLHttpRequest: function() {
		var newReq = null;
		
		if(window.XMLHttpRequest) {
			try {
				newReq = new XMLHttpRequest();
			} catch(e) {
				newReq = false;
			}
		} else if(window.ActiveXObject) {
			try {
				newReq = new ActiveXObject("Msxml2.XMLHTTP");
			} catch(e) {
				try {
					newReq = new ActiveXObject("Microsoft.XMLHTTP");
				} catch(e) {
					newReq = false;
				}
			}
		}
		
		return newReq;
	},
	
	/** Retorna o json no formato String */
	toSource: function(json) {
		return JSON.stringify(json);
	},
	
	/** Converte a resposta de String para JSON */
	toObject: function(response) {
		try {
			return eval("(" + response + ")");
		} catch(e) {
			return response;
		}
	},
	
	get: function(selector) {
		return this.jQuery(selector);
	},
	
	/** Executa a requisio */
	execute: function(classPath, methodName, parametersType, arguments, contextPath, options) {
		var ajax = this.getXMLHttpRequest();
		
		var types = new StringBuffer("");
		var args = new StringBuffer("");
		
		for(var p = 0; p < parametersType.length; p++) {
			types.append("'" + parametersType[p] + "'" + ((p == parametersType.length-1) ? "":","));
			args.append(this.toSource(this.specialTypes(arguments[p])) + ((p == parametersType.length-1) ? "":","));
		}
		
		// default config
		var async = this.defaults.async;
		var charset = this.defaults.charset;
		
		// other config
		var renderer;
		
		// events
		var onComplete;
		var onRequest;
		var onError;
		
		if(options) {
			if(options.async != null && options.async != undefined) {
				async = options.async
			}
			
			if(options.charset) {
				charset = options.charset;
			}
			
			if(options.onComplete) {
				onComplete = options.onComplete;
			}
			
			if(options.onRequest) {
				onRequest = options.onRequest;
			}
			
			if(options.onError) {
				onError = options.onError;
			}
			
			if(options.renderer) {
				renderer = options.renderer;
			}
		}
		
		// Executa a funo onRequest
		if(onRequest) {
			onRequest();
		}
		
		// Prepara a requisio
		ajax.open("POST", contextPath + "/parser", async);
		
		var ref = this;
		ajax.onreadystatechange = function() {
			if(async && ajax.readyState == 4 && ajax.status == 500) {
				onError(ref.toObject(ajax.responseText));
			}
			
			if(async && ref.jQuery && renderer && ajax.readyState == 4 && ajax.status == 200) {
				ref.get(renderer).html(ajax.responseText);
			}
			
			if(async && onComplete && ajax.readyState == 4 && ajax.status == 200) {
				onComplete(ref.toObject(ajax.responseText));
			}
		}
		
		// Efetua a requisio
		ajax.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charset);
		ajax.send("beanName=" + classPath + "&methodName=" + methodName + "&parametersTypes=[" + types.toString() + "]" + "&arguments=[" + args.toString() + "]");
		
		// Tratativas feitas para requisies sncronas (async = false)
		if(!async) {
			if(renderer && this.jQuery) {
				this.get(renderer).html(ajax.responseText);
			} else {
				// Obtm a resposta no caso da requisio ser sncrona
				var returnObject = this.toObject(ajax.responseText);
				
				if(ajax.status == 500) {
					throw returnObject;
				}
				
				return returnObject;
			}
		}
	},
	
	specialTypes: function(value) {
		if(value instanceof Date) {
			return value.getTime();
		}
		
		return value;
	}
};

Loader = new LoaderConfig(jQuery);