package com.googlecode.mad.mvntools.common;

import com.googlecode.mad.mvntools.common.core.FileUtil;
import com.googlecode.mad.mvntools.common.interfaces.IFileUtil;

/**
 * - Apache License 2.0 - <br>
 * Factory for all the Common stuff <br>
 * <br>
 * LastChangedBy: $Author: marthaler.worb@gmail.com $<br>
 * LastChangedDate: $Date: 2010-12-26 20:33:53 +0100 (Sun, 26 Dec 2010) $<br>
 * 
 * @author daniel marthaler
 * @version $Revision: 60 $
 * @since 27.12.2010
 */
public class Factory {
    
    private static Factory  instance = null;
    private final IFileUtil fileUtil = new FileUtil();
    
    private Factory() {
        
    }
    
    public static synchronized Factory getInstance() {
        if (Factory.instance == null) {
            Factory.instance = new Factory();
        }
        return Factory.instance;
    }
    
    public IFileUtil getIFileUtil() {
        return this.fileUtil;
    }
}
