package com.googlecode.mad.mvntools.common.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;

import com.googlecode.mad.mvntools.common.interfaces.IFileUtil;

/**
 * - Apache License 2.0 - <br>
 * File handling Util <br>
 * <br>
 * LastChangedBy: $Author: marthaler.worb@gmail.com $<br>
 * LastChangedDate: $Date: 2010-12-26 20:33:53 +0100 (Sun, 26 Dec 2010) $<br>
 * 
 * @author daniel marthaler
 * @version $Revision: 60 $
 * @since 24.12.2010
 */
public final class FileUtil implements IFileUtil {
    
    public FileUtil() {
        
    }
    
    /*
     * (non-Javadoc)
     * @see com.googlecode.mad.mvntools.settingsutil.common.core.FileUtilI#loadFile(java.lang.String)
     */
    public String loadFile(final String name) {
        final StringBuilder b = new StringBuilder();
        
        final URL url = FileUtil.class.getClassLoader().getResource(name);
        BufferedReader in = null;
        if (url == null) {
            return this.loadFile2(name);
        }
        try {
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String inputLine;
            
            while ((inputLine = in.readLine()) != null) {
                b.append(inputLine);
            }
            
            in.close();
        } catch (final IOException e) {
            if (in != null) {
                try {
                    in.close();
                } catch (final IOException e1) {
                    
                }
            }
        }
        return b.toString();
    }
    
    private String loadFile2(final String name) {
        final StringBuilder b = new StringBuilder();
        FileReader r = null;
        try {
            r = new FileReader(name);
        } catch (final FileNotFoundException e2) {
            return "";
        }
        
        BufferedReader in = null;
        
        try {
            in = new BufferedReader(r);
            String inputLine;
            
            while ((inputLine = in.readLine()) != null) {
                b.append(inputLine);
            }
            
            in.close();
        } catch (final IOException e) {
            if (in != null) {
                try {
                    in.close();
                } catch (final IOException e1) {
                    return "";
                }
            }
        }
        return b.toString();
    }
    
    private void setContents(final File aFile, final String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + aFile);
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        
        // use buffering
        final Writer output = new BufferedWriter(new FileWriter(aFile));
        try {
            output.write(aContents);
        } finally {
            output.close();
        }
    }
    
    /*
     * (non-Javadoc)
     * @see com.googlecode.mad.mvntools.settingsutil.common.core.FileUtilI#replaceFileWithNewContent(java.lang.String, java.lang.String)
     */
    public void replaceFileWithNewContent(final String file, final String content) {
        final File f = new File(file);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        } catch (final IOException e4) {
            
        }
        if ((content != null) && !"".equals(content)) {
            try {
                this.setContents(f, content);
            } catch (final Exception e) {
                
            }
        }
    }
    
    /*
     * (non-Javadoc)
     * @see com.googlecode.mad.mvntools.settingsutil.common.core.FileUtilI#deleteFileOrFolder(java.lang.String)
     */
    public void deleteFileOrFolder(final String file) {
        final File f1 = new File(file);
        if (f1.exists() && !f1.isDirectory()) {
            f1.delete();
            return;
        }
        if (f1.isDirectory()) {
            final String[] files = f1.list();
            for (final String string : files) {
                this.deleteFileOrFolder(f1.getAbsolutePath() + "/" + string);
            }
            f1.delete();
        }
    }
    
}
