/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mad.mvntools.common.core;

import com.googlecode.mad.mvntools.common.interfaces.IMavenVersionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MavenVersionUtil
implements IMavenVersionUtil {
    private static final String ENCODING = "UTF-8";
    private static final String VERSION = "version=";
    private final String sourcepattern = "#EEE MMM dd HH:mm:ss z yyyy";
    private final String targetpattern = "dd.MM.yy HH:mm";
    private final String file = "META-INF/maven/[group]/[artid]/pom.properties";
    private final Map<String, String> versionMap = new HashMap<String, String>();
    private final Map<String, String> dateMap = new HashMap<String, String>();

    public String getDateString(String groupid, String artifactid, Class root) {
        this.init(this.file.replace("[group]", groupid).replace("[artid]", artifactid), root);
        return this.dateMap.get(this.file.replace("[group]", groupid).replace("[artid]", artifactid));
    }

    public String getVersionString(String groupid, String artifactid, Class root) {
        this.init(this.file.replace("[group]", groupid).replace("[artid]", artifactid), root);
        return this.versionMap.get(this.file.replace("[group]", groupid).replace("[artid]", artifactid));
    }

    public String getWholeVersionString(String groupid, String artifactid, Class root) {
        return this.getVersionString(groupid, artifactid, root) + "; " + this.getDateString(groupid, artifactid, root);
    }

    public String getMavenString(String groupid, String artifactid, Class root) {
        String first = "*******************************************************************************";
        StringBuilder b = new StringBuilder();
        b.append("\n");
        b.append("*******************************************************************************");
        b.append("\n");
        b.append("*** ");
        b.append(artifactid);
        b.append(": ");
        b.append(this.getVersionString(groupid, artifactid, root));
        b.append(", built on ");
        b.append(this.getDateString(groupid, artifactid, root));
        while (b.length() + 4 < "*******************************************************************************".length()) {
            b.append(" ");
        }
        b.append("    ");
        b.append("\n");
        b.append("*******************************************************************************");
        return b.toString();
    }

    private void init(String file, Class root) {
        String date = this.dateMap.get(file);
        if (date != null && !date.equals("")) {
            return;
        }
        root.getClassLoader();
        URL url = root.getClassLoader().getResource(file);
        if (url == null) {
            return;
        }
        BufferedInputStream oin = null;
        try {
            oin = new BufferedInputStream(url.openStream());
        }
        catch (IOException e1) {
            // empty catch block
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)oin, ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains("CEST") || line.contains("CET")) {
                    SimpleDateFormat format = new SimpleDateFormat(this.sourcepattern, Locale.US);
                    try {
                        SimpleDateFormat fm = new SimpleDateFormat(this.targetpattern);
                        this.dateMap.put(file, fm.format(format.parse(line)));
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (!line.contains("version")) continue;
                this.versionMap.put(file, line.replace(VERSION, ""));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

