/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl;

import java.util.Date;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.util.Util;

public abstract class SemanticRoleLabeler {
    public long loadingTime = 0L;
    public long parsingTime = 0L;
    public int senCount = 0;
    public int predCount = 0;
    public final Date startDate = new Date();

    public void parseSentence(Sentence s) {
        long startTime = System.currentTimeMillis();
        this.parse(s);
        this.parsingTime += System.currentTimeMillis() - startTime;
        ++this.senCount;
        this.predCount += s.getPredicates().size();
    }

    protected abstract void parse(Sentence var1);

    public String getStatus() {
        StringBuilder ret = new StringBuilder("Semantic role labeler started at " + this.startDate + "\n");
        ret.append("Time spent loading SRL models (ms)\t\t" + Util.insertCommas(this.loadingTime) + "\n");
        ret.append("Time spent parsing semantic roles (ms)\t\t" + Util.insertCommas(this.parsingTime) + "\n");
        ret.append("\n");
        ret.append("Number of sentences\t" + Util.insertCommas(this.senCount) + "\n");
        ret.append("Number of predicates\t" + Util.insertCommas(this.predCount) + "\n");
        ret.append("SRL speed (ms/sen)\t" + (double)this.parsingTime / (double)this.senCount + "\n");
        ret.append(this.getSubStatus());
        return ret.toString();
    }

    protected abstract String getSubStatus();
}

