/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.ArgDependentAttrFeature;
import se.lth.cs.srl.features.ArgDependentBrown;
import se.lth.cs.srl.features.ArgDependentFeatsFeature;
import se.lth.cs.srl.features.ChildSetFeature;
import se.lth.cs.srl.features.DepSubCatFeature;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureFile;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.features.PathFeature;
import se.lth.cs.srl.features.PositionFeature;
import se.lth.cs.srl.features.PredDependentAttrFeature;
import se.lth.cs.srl.features.PredDependentBrown;
import se.lth.cs.srl.features.PredDependentFeatsFeature;
import se.lth.cs.srl.features.QDoubleChildSetFeature;
import se.lth.cs.srl.features.QSingleSetFeature;
import se.lth.cs.srl.features.QSingleSingleFeature;
import se.lth.cs.srl.features.SetFeature;
import se.lth.cs.srl.features.SingleFeature;
import se.lth.cs.srl.features.TargetWord;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.util.BrownCluster;

public class FeatureGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<FeatureName, Feature> cache = new HashMap<FeatureName, Feature>();
    private Map<String, Feature> qcache = new HashMap<String, Feature>();

    public Map<Step, FeatureSet> readFeatureFiles(Map<Step, File> files, BrownCluster bc) throws IOException {
        HashMap<Step, FeatureSet> featureSets = new HashMap<Step, FeatureSet>();
        Map<String, List<String>> piNames = FeatureFile.readFile(files.get((Object)Step.pi));
        featureSets.put(Step.pi, this.createFeatureSet(piNames, true, bc));
        for (Step s : new Step[]{Step.pd, Step.ai, Step.ac}) {
            Map<String, List<String>> names = FeatureFile.readFile(files.get((Object)s));
            featureSets.put(s, this.createFeatureSet(names, false, bc));
        }
        return featureSets;
    }

    private FeatureSet createFeatureSet(Map<String, List<String>> names, boolean includeAllWords, BrownCluster bc) {
        HashMap<String, List<Feature>> fs = new HashMap<String, List<Feature>>();
        for (String POSPrefix : names.keySet()) {
            ArrayList<Feature> list = new ArrayList<Feature>();
            fs.put(POSPrefix, list);
            for (String featureNameStr : names.get(POSPrefix)) {
                if (featureNameStr.contains("+")) {
                    String[] n = featureNameStr.split("\\+");
                    FeatureName fn1 = FeatureName.valueOf(n[0]);
                    FeatureName fn2 = FeatureName.valueOf(n[1]);
                    list.add(this.getQFeature(fn1, fn2, includeAllWords, POSPrefix, bc));
                    continue;
                }
                FeatureName fn = FeatureName.valueOf(featureNameStr);
                list.add(this.getFeature(fn, includeAllWords, POSPrefix, bc));
            }
        }
        return new FeatureSet((Map<String, List<Feature>>)fs);
    }

    public Feature getFeature(String featureNameString, boolean includeAllWords, String POSPrefix, BrownCluster bc) {
        if (featureNameString.contains("+")) {
            String[] s = featureNameString.split("\\+");
            FeatureName fn1 = FeatureName.valueOf(s[0]);
            FeatureName fn2 = FeatureName.valueOf(s[1]);
            return this.getQFeature(fn1, fn2, includeAllWords, POSPrefix, bc);
        }
        FeatureName fn = FeatureName.valueOf(featureNameString);
        return this.getFeature(fn, includeAllWords, POSPrefix, bc);
    }

    public Feature getFeature(FeatureName fn, boolean includeAllWords, String POSPrefix, BrownCluster bc) {
        Feature ret;
        if (this.cache.containsKey((Object)fn)) {
            Feature ret2 = this.cache.get((Object)fn);
            ret2.addPOSPrefix(POSPrefix);
            return ret2;
        }
        switch (fn) {
            case PredWord: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.Form, TargetWord.Pred, includeAllWords, POSPrefix);
                break;
            }
            case PredLemma: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.Lemma, TargetWord.Pred, includeAllWords, POSPrefix);
                break;
            }
            case PredPOS: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.POS, TargetWord.Pred, includeAllWords, POSPrefix);
                break;
            }
            case PredDeprel: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.Deprel, TargetWord.Pred, includeAllWords, POSPrefix);
                break;
            }
            case PredLemmaSense: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.Pred, TargetWord.Pred, false, POSPrefix);
                break;
            }
            case PredFeats: {
                ret = new PredDependentFeatsFeature(fn, TargetWord.Pred, includeAllWords, POSPrefix);
                break;
            }
            case PredParentWord: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.Form, TargetWord.PredParent, includeAllWords, POSPrefix);
                break;
            }
            case PredParentPOS: {
                ret = new PredDependentAttrFeature(fn, Word.WordData.POS, TargetWord.PredParent, includeAllWords, POSPrefix);
                break;
            }
            case PredParentFeats: {
                ret = new PredDependentFeatsFeature(fn, TargetWord.PredParent, includeAllWords, POSPrefix);
                break;
            }
            case DepSubCat: {
                ret = new DepSubCatFeature(includeAllWords, POSPrefix);
                break;
            }
            case ChildDepSet: {
                ret = new ChildSetFeature(fn, Word.WordData.Deprel, includeAllWords, POSPrefix);
                break;
            }
            case ChildWordSet: {
                ret = new ChildSetFeature(fn, Word.WordData.Form, includeAllWords, POSPrefix);
                break;
            }
            case ChildPOSSet: {
                ret = new ChildSetFeature(fn, Word.WordData.POS, includeAllWords, POSPrefix);
                break;
            }
            case ArgWord: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Form, TargetWord.Arg, POSPrefix);
                break;
            }
            case ArgPOS: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.POS, TargetWord.Arg, POSPrefix);
                break;
            }
            case ArgFeats: {
                ret = new ArgDependentFeatsFeature(fn, TargetWord.Arg, POSPrefix);
                break;
            }
            case ArgDeprel: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Deprel, TargetWord.Arg, POSPrefix);
                break;
            }
            case LeftWord: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Form, TargetWord.LeftDep, POSPrefix);
                break;
            }
            case LeftPOS: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.POS, TargetWord.LeftDep, POSPrefix);
                break;
            }
            case LeftFeats: {
                ret = new ArgDependentFeatsFeature(fn, TargetWord.LeftDep, POSPrefix);
                break;
            }
            case RightWord: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Form, TargetWord.RightDep, POSPrefix);
                break;
            }
            case RightPOS: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.POS, TargetWord.RightDep, POSPrefix);
                break;
            }
            case RightFeats: {
                ret = new ArgDependentFeatsFeature(fn, TargetWord.RightDep, POSPrefix);
                break;
            }
            case LeftSiblingWord: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Form, TargetWord.LeftSibling, POSPrefix);
                break;
            }
            case LeftSiblingPOS: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.POS, TargetWord.LeftSibling, POSPrefix);
                break;
            }
            case LeftSiblingFeats: {
                ret = new ArgDependentFeatsFeature(fn, TargetWord.LeftSibling, POSPrefix);
                break;
            }
            case RightSiblingWord: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.Form, TargetWord.RightSibling, POSPrefix);
                break;
            }
            case RightSiblingPOS: {
                ret = new ArgDependentAttrFeature(fn, Word.WordData.POS, TargetWord.RightSibling, POSPrefix);
                break;
            }
            case RightSiblingFeats: {
                ret = new ArgDependentFeatsFeature(fn, TargetWord.RightSibling, POSPrefix);
                break;
            }
            case POSPath: {
                ret = new PathFeature(fn, Word.WordData.POS, POSPrefix);
                break;
            }
            case DeprelPath: {
                ret = new PathFeature(fn, Word.WordData.Deprel, POSPrefix);
                break;
            }
            case Position: {
                ret = new PositionFeature(POSPrefix);
                break;
            }
            default: {
                if (fn.toString().startsWith("Brown")) {
                    if (bc == null) {
                        throw new RuntimeException("Cannot use brown cluster features unless a cluster is provided on the cmd line");
                    }
                    BrownCluster.ClusterVal cv = fn.toString().contains("Short") ? BrownCluster.ClusterVal.SHORT : BrownCluster.ClusterVal.LONG;
                    TargetWord tw = TargetWord.valueOf(fn.toString().substring("Brown".length() + cv.toString().length()));
                    if (fn.toString().contains("Pred")) {
                        ret = new PredDependentBrown(fn, tw, includeAllWords, POSPrefix, bc, cv);
                        break;
                    }
                    ret = new ArgDependentBrown(fn, tw, POSPrefix, bc, cv);
                    break;
                }
                throw new Error("You are wrong here. Check your implementation.");
            }
        }
        this.cache.put(fn, ret);
        return ret;
    }

    public Feature getQFeature(FeatureName fn1, FeatureName fn2, boolean includeAllWords, String POSPrefix, BrownCluster bc) {
        Feature ret;
        String fnameStr = FeatureGenerator.getCanonicalQFeatureName(fn1, fn2);
        if (this.qcache.containsKey(fnameStr)) {
            Feature ret2 = this.qcache.get(fnameStr);
            ret2.addPOSPrefix(POSPrefix);
            return ret2;
        }
        Feature f1 = this.getFeature(fn1, includeAllWords, null, bc);
        Feature f2 = this.getFeature(fn2, includeAllWords, null, bc);
        if (f1 instanceof SingleFeature) {
            ret = f2 instanceof SingleFeature ? new QSingleSingleFeature((SingleFeature)f1, (SingleFeature)f2, includeAllWords, POSPrefix) : new QSingleSetFeature((SingleFeature)f1, (SetFeature)f2, includeAllWords, POSPrefix);
        } else if (f2 instanceof SingleFeature) {
            ret = new QSingleSetFeature((SingleFeature)f2, (SetFeature)f1, includeAllWords, POSPrefix);
        } else if (f1 instanceof ChildSetFeature && f2 instanceof ChildSetFeature) {
            ret = new QDoubleChildSetFeature((ChildSetFeature)f1, (ChildSetFeature)f2, includeAllWords, POSPrefix);
        } else {
            throw new IllegalArgumentException("Features " + f1.getName() + " and " + f2.getName() + " can not be combined. Change your feature file");
        }
        this.qcache.put(FeatureGenerator.getCanonicalQFeatureName(fn1, fn2), ret);
        return ret;
    }

    private static String getCanonicalQFeatureName(String featureNameString) {
        String[] s = featureNameString.split("\\+");
        FeatureName fn1 = FeatureName.valueOf(s[0]);
        FeatureName fn2 = FeatureName.valueOf(s[1]);
        return FeatureGenerator.getCanonicalQFeatureName(fn1, fn2);
    }

    private static String getCanonicalQFeatureName(FeatureName f1, FeatureName f2) {
        if (f1.compareTo(f2) > 0) {
            return f1.toString() + "+" + f2.toString();
        }
        return f2.toString() + "+" + f1.toString();
    }

    public static String getCanonicalName(FeatureName fn1, FeatureName fn2) {
        if (fn2 == null) {
            return fn1.toString();
        }
        return FeatureGenerator.getCanonicalQFeatureName(fn1, fn2);
    }

    public Feature getCachedFeature(String featureNameString) {
        Feature ret = featureNameString.contains("+") ? this.qcache.get(FeatureGenerator.getCanonicalQFeatureName(featureNameString)) : this.cache.get((Object)FeatureName.valueOf(featureNameString));
        if (ret == null) {
            throw new Error("Trying to read a cached feature that doesn't exist. Did you do something nasty with your model? Otherwise the implementation is wrong.");
        }
        return ret;
    }

    public void buildFeatureMaps(Iterable<Sentence> sentences) {
        System.out.println("Extracting features (first pass)...");
        this.buildFeatureMaps(sentences, false);
        for (Feature f : this.cache.values()) {
            f.setDoneWithPredFeatureExtraction();
        }
        for (Feature f : this.qcache.values()) {
            f.setDoneWithPredFeatureExtraction();
        }
        System.out.println("Extracting features (second pass)...");
        this.buildFeatureMaps(sentences, true);
        for (Feature f : this.cache.values()) {
            System.out.println(f);
        }
        for (Feature f : this.qcache.values()) {
            System.out.println(f);
        }
    }

    private void buildFeatureMaps(Iterable<Sentence> sentences, boolean includeAllWords) {
        Iterator<FeatureName> it = this.cache.keySet().iterator();
        while (it.hasNext()) {
            if (this.cache.get((Object)((Object)it.next())).POSPrefix != null) continue;
            it.remove();
        }
        for (Sentence s : sentences) {
            for (Feature f : this.cache.values()) {
                f.extractFeatures(s, includeAllWords);
            }
            for (Feature f : this.qcache.values()) {
                f.extractFeatures(s, includeAllWords);
            }
        }
    }
}

