/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatsFeature;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.TargetWord;
import se.lth.cs.srl.languages.Language;

public class PredDependentFeatsFeature
extends FeatsFeature {
    private static final long serialVersionUID = 1L;

    protected PredDependentFeatsFeature(FeatureName name, TargetWord tw, boolean usedForPredicateIdentification, String POSPrefix) {
        super(name, tw, false, usedForPredicateIdentification, POSPrefix);
    }

    @Override
    public String[] getFeatureStrings(Sentence s, int predIndex, int argIndex) {
        Word w = this.wordExtractor.getWord(s, predIndex, argIndex);
        return Language.getLanguage().getFeatSplitPattern().split(w.getFeats());
    }

    @Override
    public String[] getFeatureStrings(Predicate pred, Word arg) {
        Word w = this.wordExtractor.getWord(pred, arg);
        return Language.getLanguage().getFeatSplitPattern().split(w.getFeats());
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (allWords) {
            int size = s.size();
            for (int i = 1; i < size; ++i) {
                if (!this.doExtractFeatures((Word)s.get(i))) continue;
                for (String v : this.getFeatureStrings(s, i, -1)) {
                    this.addMap(v);
                }
            }
        } else {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (String v : this.getFeatureStrings(pred, null)) {
                    this.addMap(v);
                }
            }
        }
    }
}

