/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Set;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.ChildSetFeature;
import se.lth.cs.srl.features.FeatureGenerator;
import se.lth.cs.srl.features.QuadraticFeature;
import se.lth.cs.srl.features.SetFeature;

public class QDoubleChildSetFeature
extends SetFeature
implements QuadraticFeature {
    private static final long serialVersionUID = 1L;
    private ChildSetFeature f1;
    private ChildSetFeature f2;

    protected QDoubleChildSetFeature(ChildSetFeature f1, ChildSetFeature f2, boolean usedForPredicateIdentification, String POSPrefix) {
        super(f1.name, f1.includeArgs && f2.includeArgs, usedForPredicateIdentification, POSPrefix);
        this.f1 = f1;
        this.f2 = f2;
    }

    @Override
    public String[] getFeatureStrings(Sentence s, int predIndex, int argIndex) {
        return this.makeFeatureStrings(((Word)s.get(predIndex)).getChildren());
    }

    @Override
    public String[] getFeatureStrings(Predicate pred, Word arg) {
        return this.makeFeatureStrings(pred.getChildren());
    }

    private String[] makeFeatureStrings(Set<Word> children) {
        String[] ret = new String[children.size()];
        int i = 0;
        for (Word child : children) {
            ret[i++] = child.getAttr(this.f1.attr) + " + " + child.getAttr(this.f2.attr);
        }
        return ret;
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (this.includeArgs) {
            throw new Error("You are wrong here.");
        }
        if (allWords) {
            int size = s.size();
            for (int i = 1; i < size; ++i) {
                if (!this.doExtractFeatures((Word)s.get(i))) continue;
                for (String v : this.getFeatureStrings(s, i, -1)) {
                    this.addMap(v);
                }
            }
        } else {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (String v : this.getFeatureStrings(pred, null)) {
                    this.addMap(v);
                }
            }
        }
    }

    @Override
    public String getName() {
        return FeatureGenerator.getCanonicalName(this.f1.name, this.f2.name);
    }
}

