/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureGenerator;
import se.lth.cs.srl.features.QuadraticFeature;
import se.lth.cs.srl.features.SetFeature;
import se.lth.cs.srl.features.SingleFeature;

public class QSingleSetFeature
extends SetFeature
implements QuadraticFeature {
    private static final long serialVersionUID = 1L;
    private SingleFeature f1;
    private SetFeature f2;

    protected QSingleSetFeature(SingleFeature f1, SetFeature f2, boolean usedForPredicateIdentification, String POSPrefix) {
        super(f1.name, f1.includeArgs || f2.includeArgs, usedForPredicateIdentification, POSPrefix);
        this.f1 = f1;
        this.f2 = f2;
    }

    @Override
    public String[] getFeatureStrings(Sentence s, int predIndex, int argIndex) {
        String f1val = this.f1.getFeatureString(s, predIndex, argIndex);
        String[] f2vals = this.f2.getFeatureStrings(s, predIndex, argIndex);
        this.makeFeatureStrings(f1val, f2vals);
        return f2vals;
    }

    @Override
    public String[] getFeatureStrings(Predicate pred, Word arg) {
        String f1val = this.f1.getFeatureString(pred, arg);
        String[] f2vals = this.f2.getFeatureStrings(pred, arg);
        if (f2vals != null) {
            this.makeFeatureStrings(f1val, f2vals);
            return f2vals;
        }
        return new String[]{""};
    }

    private void makeFeatureStrings(String f1val, String[] f2vals) {
        int i = 0;
        int length = f2vals.length;
        while (i < length) {
            int n = i++;
            f2vals[n] = f2vals[n] + " + " + f1val;
        }
    }

    @Override
    public String getName() {
        return FeatureGenerator.getCanonicalName(this.f1.name, this.f2.name);
    }
}

