/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Collection;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureName;

public abstract class SetFeature
extends Feature {
    private static final long serialVersionUID = 1L;

    protected SetFeature(FeatureName name, boolean includeArgs, boolean usedForPredicateIdentification, String POSPrefix) {
        super(name, includeArgs, usedForPredicateIdentification, POSPrefix);
    }

    public abstract String[] getFeatureStrings(Sentence var1, int var2, int var3);

    public abstract String[] getFeatureStrings(Predicate var1, Word var2);

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (this.includeArgs) {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (Word arg : pred.getArgMap().keySet()) {
                    for (String v : this.getFeatureStrings(pred, arg)) {
                        this.addMap(v);
                    }
                }
            }
        } else if (allWords) {
            int size = s.size();
            for (int i = 1; i < size; ++i) {
                if (!this.doExtractFeatures((Word)s.get(i))) continue;
                for (String v : this.getFeatureStrings(s, i, -1)) {
                    this.addMap(v);
                }
            }
        } else {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (String v : this.getFeatureStrings(pred, null)) {
                    this.addMap(v);
                }
            }
        }
    }

    @Override
    public void addFeatures(Sentence s, Collection<Integer> indices, int predIndex, int argIndex, Integer offset, boolean allWords) {
        for (String v : this.getFeatureStrings(s, predIndex, argIndex)) {
            Integer i = this.indexOf(v);
            if (i == -1 || !allWords && i >= this.predMaxIndex) continue;
            indices.add(i + offset);
        }
    }

    @Override
    public void addFeatures(Collection<Integer> indices, Predicate pred, Word arg, Integer offset, boolean allWords) {
        for (String v : this.getFeatureStrings(pred, arg)) {
            Integer i = this.indexOf(v);
            if (i == -1 || !allWords && i >= this.predMaxIndex) continue;
            indices.add(i + offset);
        }
    }
}

