/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Collection;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureName;

public abstract class SingleFeature
extends Feature {
    private static final long serialVersionUID = 1L;

    protected SingleFeature(FeatureName name, boolean includeArgs, boolean usedForPredicateIdentification, String POSPrefix) {
        super(name, includeArgs, usedForPredicateIdentification, POSPrefix);
    }

    @Override
    public void addFeatures(Sentence s, Collection<Integer> indices, int predIndex, int argIndex, Integer offset, boolean allWords) {
        Integer i = this.indexOf(this.getFeatureString(s, predIndex, argIndex));
        if (i != -1 && (allWords || i < this.predMaxIndex)) {
            indices.add(i + offset);
        }
    }

    @Override
    public void addFeatures(Collection<Integer> indices, Predicate pred, Word arg, Integer offset, boolean allWords) {
        Integer i = this.indexOf(this.getFeatureString(pred, arg));
        if (i != -1 && (allWords || i < this.predMaxIndex)) {
            indices.add(i + offset);
        }
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (this.includeArgs) {
            throw new Error("You are wrong here, check your implementation.");
        }
        if (allWords) {
            int size = s.size();
            for (int i = 1; i < size; ++i) {
                if (!this.doExtractFeatures((Word)s.get(i))) continue;
                this.addMap(this.getFeatureString(s, i, -1));
            }
        } else {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                this.addMap(this.getFeatureString(pred, null));
            }
        }
    }

    public abstract String getFeatureString(Sentence var1, int var2, int var3);

    public abstract String getFeatureString(Predicate var1, Word var2);
}

