/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import se.lth.cs.srl.http.AbstractPipeline;

public abstract class AbstractHandler
implements HttpHandler {
    private static final Pattern ampPattern = Pattern.compile("&");
    private static final Pattern eqPattern = Pattern.compile("=");
    protected static final String sentenceDataVarName = "sentence";
    protected final AbstractPipeline pipeline;

    protected AbstractHandler(AbstractPipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected String getContent(HttpExchange exchange) throws IOException {
        String input;
        BufferedReader httpInput = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), "UTF-8"));
        StringBuilder in = new StringBuilder();
        while ((input = httpInput.readLine()) != null) {
            in.append(input).append(" ");
        }
        httpInput.close();
        return in.toString().trim();
    }

    protected static Map<String, String> contentToVariableMap(String content) throws IOException {
        String[] pairs;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String pair : pairs = ampPattern.split(content)) {
            String[] a = eqPattern.split(pair, 2);
            ret.put(URLDecoder.decode(a[0], "UTF-8"), URLDecoder.decode(a[1], "UTF-8"));
        }
        return ret;
    }

    protected void sendContent(HttpExchange exchange, String content, String content_type, int responseCode) throws IOException {
        exchange.getResponseHeaders().add("Content-type", content_type);
        byte[] bytes = content.getBytes("UTF-8");
        exchange.sendResponseHeaders(200, bytes.length);
        BufferedOutputStream os = new BufferedOutputStream(exchange.getResponseBody());
        ((OutputStream)os).write(bytes);
        ((OutputStream)os).close();
    }

    static void dumpHeaders(HttpExchange exchange) {
        System.out.println("Headers: ");
        Headers h = exchange.getRequestHeaders();
        for (Map.Entry<String, List<String>> he : h.entrySet()) {
            System.out.println(he.getKey());
            for (String v : he.getValue()) {
                System.out.println("\t" + v);
            }
        }
    }

    static String getHeader(HttpExchange exchange, String header) {
        Headers h = exchange.getRequestHeaders();
        Object values = h.get(header);
        if (values == null || values.size() == 0) {
            return null;
        }
        return (String)values.get(0);
    }
}

