/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Map;
import se.lth.cs.srl.http.DefaultHandler;
import se.lth.cs.srl.http.ParseRequestHandler;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.HttpOptions;

public abstract class AbstractPipeline {
    protected final int sentenceMaxLength;
    protected final String HTML_TOP_EXTRA;
    protected final String HTML_BOTTOM_EXTRA;

    public abstract String getStatusString();

    public abstract String getHTMLHead();

    public abstract String getHTMLTail();

    public abstract String getParseInterfaceHTML(Language.L var1);

    public abstract ParseRequestHandler.StringPair parseRequest(String var1, Map<String, String> var2) throws Exception;

    public abstract DefaultHandler getDefaultHandler();

    protected AbstractPipeline(int sentenceMaxLength, HttpOptions options) {
        this.sentenceMaxLength = sentenceMaxLength;
        this.HTML_TOP_EXTRA = options.pageTopHTMLFile != null ? AbstractPipeline.slurp(options.pageTopHTMLFile) : "";
        this.HTML_BOTTOM_EXTRA = options.pageBottomHTMLFile != null ? AbstractPipeline.slurp(options.pageBottomHTMLFile) : "";
    }

    private static String slurp(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuilder in = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                in.append(line).append('\n');
            }
            reader.close();
            return in.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class SentenceTooLongException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        public final int length;

        public SentenceTooLongException(String message, int length) {
            super(message);
            this.length = length;
        }
    }
}

