/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.lth.cs.srl.http.AbstractHandler;
import se.lth.cs.srl.http.AbstractPipeline;
import se.lth.cs.srl.languages.Language;

public class DefaultHandler
extends AbstractHandler {
    protected final Map<String, String> pages = new HashMap<String, String>();
    private final String HTML_HEAD;
    private final String HTML_TAIL;

    public DefaultHandler(Language.L currentL, AbstractPipeline pipeline) {
        super(pipeline);
        this.setupPages(currentL);
        this.HTML_HEAD = pipeline.getHTMLHead();
        this.HTML_TAIL = pipeline.getHTMLTail();
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        this.servePage("default", exchange);
    }

    private void servePage(String pageName, HttpExchange exchange) throws IOException {
        String content;
        this.getContent(exchange);
        if (pageName.equals("default")) {
            content = this.HTML_HEAD + this.pipeline.HTML_TOP_EXTRA + this.pages.get(pageName) + this.pipeline.HTML_BOTTOM_EXTRA + this.HTML_TAIL;
        } else if (pageName.equals("notReady")) {
            content = this.HTML_HEAD + this.pages.get(pageName) + this.HTML_TAIL;
        } else {
            return;
        }
        this.sendContent(exchange, content, "text/html; charset=utf-8", 200);
    }

    private void setupPages(Language.L currentL) {
        this.pages.put("default", this.pipeline.getParseInterfaceHTML(currentL));
        this.pages.put("notReady", "Pipeline is not loaded yet, please be patient. (Shouldn't be longer than 1-2 minutes, roughly)\n");
    }
}

