/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import se.lth.cs.srl.http.AbstractPipeline;
import se.lth.cs.srl.http.DefaultHandler;
import se.lth.cs.srl.http.ImageCache;
import se.lth.cs.srl.http.ImageRequestHandler;
import se.lth.cs.srl.http.ParseRequestHandler;
import se.lth.cs.srl.http.ParserStatusHandler;
import se.lth.cs.srl.options.HttpOptions;

public class HttpPipeline {
    private static HttpServer server;
    public static final Date serverStart;
    public static final ImageCache imageCache;
    private static HttpPipeline h;

    private HttpPipeline(AbstractPipeline pipeline, HttpOptions options) throws IOException {
        DefaultHandler defaultHandler = pipeline.getDefaultHandler();
        server = HttpServer.create(new InetSocketAddress(options.port), 0);
        server.createContext("/", defaultHandler);
        server.start();
        System.out.println("Server up and listening on port " + options.port);
        System.out.println("Setting up pipeline");
        ParseRequestHandler parseHandler = new ParseRequestHandler(defaultHandler, pipeline);
        server.createContext("/parse", parseHandler);
        ParserStatusHandler statusHandler = new ParserStatusHandler(pipeline);
        server.createContext("/status", statusHandler);
        ImageRequestHandler imgHandler = new ImageRequestHandler(imageCache);
        server.createContext("/img", imgHandler);
    }

    public static void setupHttpPipeline(HttpOptions options, AbstractPipeline pipeline) {
        block3: {
            if (h != null) {
                throw new Error("don't go here twice");
            }
            try {
                h = new HttpPipeline(pipeline, options);
            }
            catch (Exception e) {
                System.out.println("Caught exception while setting up server, exiting.");
                e.printStackTrace(System.out);
                System.out.println();
                if (server == null) break block3;
                server.stop(0);
            }
        }
    }

    static {
        serverStart = new Date();
        imageCache = new ImageCache(3600000L, 3600000L, 1000);
    }
}

