/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import se.lth.cs.srl.http.AbstractHandler;
import se.lth.cs.srl.http.AbstractPipeline;
import se.lth.cs.srl.http.DefaultHandler;

public class ParseRequestHandler
extends AbstractHandler {
    private DefaultHandler defaultHandler;
    private static final Pattern WHITESPACE_ONLY_PATTERN = Pattern.compile("^\\s+$");

    public ParseRequestHandler(DefaultHandler defaultHandler, AbstractPipeline pipeline) throws IOException {
        super(pipeline);
        this.defaultHandler = defaultHandler;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String content_type;
        String httpResponse;
        if (!exchange.getRequestMethod().equals("POST")) {
            this.defaultHandler.handle(exchange);
            return;
        }
        Map<String, String> vars = AbstractHandler.contentToVariableMap(this.getContent(exchange));
        String inputSentence = vars.get("sentence");
        if (inputSentence == null || inputSentence.length() == 0 || WHITESPACE_ONLY_PATTERN.matcher(inputSentence).matches()) {
            this.sendContent(exchange, "Error, invalid request.", "text/plain", 400);
            return;
        }
        String userAgent = AbstractHandler.getHeader(exchange, "User-agent");
        String xForwardedFor = AbstractHandler.getHeader(exchange, "X-forwarded-for");
        System.out.println("@Parsing ``" + inputSentence + "'' at " + new Date(System.currentTimeMillis()));
        System.out.println("Requested by " + exchange.getRemoteAddress() + (xForwardedFor == null ? "" : " (Forwarded for " + xForwardedFor + ")") + ". Agent: " + userAgent);
        try {
            StringPair res = this.pipeline.parseRequest(inputSentence, vars);
            httpResponse = res.s1;
            content_type = res.s2;
        }
        catch (AbstractPipeline.SentenceTooLongException e) {
            this.sendContent(exchange, "Sentence too long (" + e.length + " tokens). Request denied.", "text/plain", 413);
            System.out.println("Aborting, sentence too long: " + e.length + " tokens.");
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            content_type = "text/plain";
            httpResponse = "Server crashed.";
            this.sendContent(exchange, httpResponse, content_type, 500);
            System.err.println("Server crashed. Exiting.");
            System.exit(1);
        }
        this.sendContent(exchange, httpResponse, content_type, 200);
    }

    static class StringPair {
        final String s1;
        final String s2;

        StringPair(String s1, String s2) {
            this.s1 = s1;
            this.s2 = s2;
        }
    }
}

