/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http.whatswrongglue;

import com.googlecode.whatswrong.NLPCanvasRenderer;
import com.googlecode.whatswrong.NLPInstance;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class Export {
    private static BufferedImage getImage(NLPCanvasRenderer renderer, NLPInstance instance, double scaleFactor) {
        BufferedImage image = new BufferedImage(1, 1, 6);
        Graphics2D graphics = image.createGraphics();
        Dimension d = renderer.render(instance, graphics);
        if (scaleFactor != 1.0) {
            d = new Dimension((int)((double)d.width * scaleFactor), (int)((double)d.height * scaleFactor));
        }
        image = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 6);
        graphics = image.createGraphics();
        if (scaleFactor != 1.0) {
            graphics.scale(scaleFactor, scaleFactor);
        }
        renderer.render(instance, graphics);
        return image;
    }

    public static void exportToJPG(File file, NLPCanvasRenderer renderer, NLPInstance instance, double scaleFactor) throws FileNotFoundException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        Export.exportToJPG(os, renderer, instance, scaleFactor);
        os.close();
    }

    public static void exportToJPG(OutputStream os, NLPCanvasRenderer renderer, NLPInstance instance, double scaleFactor) throws IOException {
        BufferedImage image = Export.getImage(renderer, instance, scaleFactor);
        ImageIO.write((RenderedImage)image, "JPG", os);
    }

    public static void exportToPNG(File file, NLPCanvasRenderer renderer, NLPInstance instance, double scaleFactor) throws FileNotFoundException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        Export.exportToPNG(os, renderer, instance, scaleFactor);
        os.close();
    }

    public static void exportToPNG(OutputStream os, NLPCanvasRenderer renderer, NLPInstance instance, double scaleFactor) throws IOException {
        BufferedImage image = Export.getImage(renderer, instance, scaleFactor);
        ImageIO.write((RenderedImage)image, "PNG", os);
    }
}

