/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.languages;

import is2.lemmatizer.Lemmatizer;
import is2.parser.Parser;
import is2.tag.Tagger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.languages.Chinese;
import se.lth.cs.srl.languages.English;
import se.lth.cs.srl.languages.French;
import se.lth.cs.srl.languages.German;
import se.lth.cs.srl.languages.NullLanguage;
import se.lth.cs.srl.languages.Spanish;
import se.lth.cs.srl.languages.Swedish;
import se.lth.cs.srl.options.FullPipelineOptions;
import se.lth.cs.srl.preprocessor.Preprocessor;
import se.lth.cs.srl.preprocessor.tokenization.OpenNLPToolsTokenizerWrapper;
import se.lth.cs.srl.preprocessor.tokenization.Tokenizer;
import se.lth.cs.srl.preprocessor.tokenization.WhiteSpaceTokenizer;
import se.lth.cs.srl.util.BohnetHelper;

public abstract class Language {
    private static Language language;
    static final Pattern BAR_PATTERN;

    public abstract String toLangNameString();

    public static Language getLanguage() {
        return language;
    }

    public static String getLsString() {
        return "chi, eng, ger";
    }

    public static Language setLanguage(L l) {
        switch (l) {
            case chi: {
                language = new Chinese();
                break;
            }
            case eng: {
                language = new English();
                break;
            }
            case ger: {
                language = new German();
                break;
            }
            case swe: {
                language = new Swedish();
                break;
            }
            case spa: {
                language = new Spanish();
                break;
            }
            case fre: {
                language = new French();
                break;
            }
            case nul: {
                language = new NullLanguage();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown language: '" + (Object)((Object)l) + "'");
            }
        }
        return language;
    }

    public Pattern getFeatSplitPattern() {
        return BAR_PATTERN;
    }

    public abstract String getDefaultSense(Predicate var1);

    public abstract String getCoreArgumentLabelSequence(Predicate var1, Map<Word, String> var2);

    public abstract L getL();

    public abstract String getLexiconURL(Predicate var1);

    public Preprocessor getPreprocessor(FullPipelineOptions options) throws IOException {
        Tokenizer tokenizer = options.loadPreprocessorWithTokenizer ? this.getTokenizer(options.tokenizer) : null;
        Lemmatizer lemmatizer = this.getLemmatizer(options.lemmatizer);
        Tagger tagger = options.tagger == null ? null : BohnetHelper.getTagger(options.tagger);
        is2.mtag.Tagger mtagger = options.morph == null ? null : BohnetHelper.getMTagger(options.morph);
        Parser parser = options.parser == null ? null : BohnetHelper.getParser(options.parser);
        Preprocessor pp = new Preprocessor(tokenizer, lemmatizer, tagger, mtagger, parser);
        return pp;
    }

    public abstract String verifyLanguageSpecificModelFiles(FullPipelineOptions var1);

    Tokenizer getDefaultTokenizer() {
        return new WhiteSpaceTokenizer();
    }

    public Tokenizer getTokenizer(File tokenModelFile) throws IOException {
        if (tokenModelFile == null) {
            return this.getDefaultTokenizer();
        }
        return this.getTokenizerFromModelFile(tokenModelFile);
    }

    Tokenizer getTokenizerFromModelFile(File tokenModelFile) throws IOException {
        return OpenNLPToolsTokenizerWrapper.loadOpenNLPTokenizer(tokenModelFile);
    }

    Lemmatizer getLemmatizer(File lemmaModelFile) throws IOException {
        if (lemmaModelFile == null) {
            return null;
        }
        return BohnetHelper.getLemmatizer(lemmaModelFile);
    }

    static {
        BAR_PATTERN = Pattern.compile("\\|");
    }

    public static enum L {
        cat,
        chi,
        cze,
        eng,
        ger,
        jap,
        spa,
        swe,
        fre,
        nul;

    }
}

