/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.options;

import java.io.File;
import se.lth.cs.srl.Parse;
import se.lth.cs.srl.options.Options;

public class ParseOptions
extends Options {
    public boolean skipPI = false;
    public boolean useReranker = false;
    public File output;
    public double global_alfa = 1.0;

    ParseOptions() {
    }

    public ParseOptions(String[] args) {
        this.superParseCmdLine(args);
    }

    @Override
    int parseCmdLine(String[] args, int ai) {
        if (ai == args.length - 1) {
            this.output = new File(args[ai]);
            return ai + 1;
        }
        if (args[ai].equals("-nopi")) {
            ++ai;
            this.skipPI = true;
        } else if (args[ai].equals("-reranker")) {
            ++ai;
            this.useReranker = true;
        } else if (args[ai].equals("-alfa")) {
            this.global_alfa = Double.parseDouble(args[++ai]);
            ++ai;
        }
        return ai;
    }

    @Override
    void usage() {
        System.err.println("Usage:");
        System.err.println(" java -cp <classpath> " + Parse.class.getName() + " <lang> <input-corpus> <model-file> [options] <output>");
        System.err.println();
        System.err.println("Example:");
        System.err.println(" java -cp srl.jar:lib/liblinear-1.51-with-deps.jar" + Parse.class.getName() + " eng ~/corpora/eng/CoNLL2009-ST-English-evaluation-SRLonly.txt eng-srl.mdl -reranker -nopi -alfa 1.0 eng-eval.out");
        System.err.println();
        System.err.println(" parses in the input corpus using the model eng-srl.mdl and saves it to eng-eval.out, using a reranker and skipping the predicate identification step");
        System.err.println();
        super.printUsageLanguages(System.err);
        System.err.println();
        super.printUsageOptions(System.err);
        System.err.println();
        System.err.println("Parsing-specific options:");
        System.err.println(" -nopi           skips the predicate identification. This is equivalent to the");
        System.err.println("                 setting in the CoNLL 2009 ST.");
        System.err.println(" -reranker       uses a reranker (assumed to be included in the model)");
        System.err.println(" -alfa <double>  the alfa used by the reranker. (default " + this.global_alfa + ")");
    }

    @Override
    boolean verifyArguments() {
        if (!this.modelFile.exists() || !this.modelFile.canRead()) {
            System.err.println("Model file " + this.modelFile + " does not exist or can not be read. Aborting.");
            System.exit(1);
        }
        return true;
    }
}

