/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.ml.LearningProblem;
import se.lth.cs.srl.ml.Model;
import se.lth.cs.srl.ml.liblinear.LibLinearLearningProblem;
import se.lth.cs.srl.pipeline.PipelineStep;

public abstract class AbstractStep
implements PipelineStep {
    public static final Integer POSITIVE = 1;
    public static final Integer NEGATIVE = 0;
    protected FeatureSet featureSet;
    protected Map<String, LearningProblem> learningProblems;
    protected Map<String, Model> models;

    public AbstractStep(FeatureSet fs) {
        this.featureSet = fs;
    }

    public void prepareLearning(String filePrefix) {
        this.learningProblems = new HashMap<String, LearningProblem>();
        for (String POS : this.featureSet.POSPrefixes) {
            File dataFile = new File(Learn.learnOptions.tempDir, filePrefix + POS);
            this.learningProblems.put(POS, new LibLinearLearningProblem(dataFile, false));
        }
    }

    @Override
    public abstract void extractInstances(Sentence var1);

    @Override
    public abstract void parse(Sentence var1);

    @Override
    public void done() {
        for (LearningProblem lp : this.learningProblems.values()) {
            lp.done();
        }
    }

    @Override
    public void train() {
        this.models = new HashMap<String, Model>();
        for (String POSPrefix : this.learningProblems.keySet()) {
            LearningProblem lp = this.learningProblems.get(POSPrefix);
            Model m = lp.train();
            this.models.put(POSPrefix, m);
        }
    }

    protected abstract String getModelFileName();

    @Override
    public void readModels(ZipFile zipFile) throws IOException, ClassNotFoundException {
        this.models = new HashMap<String, Model>();
        AbstractStep.readModels(zipFile, this.models, this.getModelFileName());
    }

    @Override
    public void writeModels(ZipOutputStream zos) throws IOException {
        AbstractStep.writeModels(zos, this.models, this.getModelFileName());
    }

    static void readModels(ZipFile zipFile, Map<String, Model> models, String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(zipFile.getInputStream(zipFile.getEntry(filename)));
        int numberOfModels = ois.readInt();
        for (int i = 0; i < numberOfModels; ++i) {
            String POSPrefix = (String)ois.readObject();
            Model m = (Model)ois.readObject();
            models.put(POSPrefix, m);
        }
    }

    static void writeModels(ZipOutputStream zos, Map<String, Model> models, String filename) throws IOException {
        zos.putNextEntry(new ZipEntry(filename));
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        int numberOfModels = models.size();
        oos.writeInt(numberOfModels);
        for (String POSPrefix : models.keySet()) {
            oos.writeObject(POSPrefix);
            oos.writeObject(models.get(POSPrefix));
        }
        oos.flush();
    }
}

