/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigIntegerSerializer
extends Serializer {
    public BigInteger readObjectData(ByteBuffer buffer, Class type) {
        int length = IntSerializer.get(buffer, true);
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        BigInteger value = new BigInteger(bytes);
        if (Log.TRACE) {
            Log.trace("kryo", "Read BigInteger: " + value);
        }
        return value;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        BigInteger value = (BigInteger)object;
        byte[] bytes = value.toByteArray();
        IntSerializer.put(buffer, bytes.length, true);
        buffer.put(bytes);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote BigInteger: " + value);
        }
    }
}

