/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;

public class EnumMapSerializer
extends SimpleSerializer<EnumMap<? extends Enum<?>, ?>> {
    private static final Field TYPE_FIELD;
    private final Kryo _kryo;

    public EnumMapSerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    @Override
    public EnumMap<?, ?> read(ByteBuffer buffer) {
        Class keyType = this._kryo.readClass(buffer).getType();
        EnumMap result = new EnumMap(keyType);
        int size = IntSerializer.get(buffer, true);
        for (int i = 0; i < size; ++i) {
            Object key = EnumSerializer.get(buffer, keyType);
            Object value = this._kryo.readClassAndObject(buffer);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void write(ByteBuffer buffer, EnumMap<? extends Enum<?>, ?> map) {
        this._kryo.writeClass(buffer, this.getKeyType(map));
        IntSerializer.put(buffer, map.size(), true);
        for (Map.Entry<Enum<?>, ?> entry : map.entrySet()) {
            EnumSerializer.put(buffer, entry.getKey());
            this._kryo.writeClassAndObject(buffer, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote EnumMap: " + map);
        }
    }

    private Class getKeyType(EnumMap<?, ?> map) {
        try {
            return (Class)TYPE_FIELD.get(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            TYPE_FIELD = EnumMap.class.getDeclaredField("keyType");
            TYPE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The EnumMap class seems to have changed, could not access expected field.", e);
        }
    }
}

