/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.LongSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.StringSerializer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GregorianCalendarSerializer
extends SimpleSerializer<GregorianCalendar> {
    private final Field _zoneField;

    public GregorianCalendarSerializer() {
        try {
            this._zoneField = Calendar.class.getDeclaredField("zone");
            this._zoneField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GregorianCalendar read(ByteBuffer buffer) {
        Calendar result = GregorianCalendar.getInstance();
        result.setTimeInMillis(LongSerializer.get(buffer, true));
        result.setLenient(this.fromInt(IntSerializer.get(buffer, true)));
        result.setFirstDayOfWeek(IntSerializer.get(buffer, true));
        result.setMinimalDaysInFirstWeek(IntSerializer.get(buffer, true));
        String timeZoneId = StringSerializer.get(buffer);
        if (!this.getTimeZone(result).getID().equals(timeZoneId)) {
            result.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        }
        return (GregorianCalendar)result;
    }

    @Override
    public void write(ByteBuffer buffer, GregorianCalendar calendar) {
        LongSerializer.put(buffer, calendar.getTimeInMillis(), true);
        IntSerializer.put(buffer, this.toInt(calendar.isLenient()), true);
        IntSerializer.put(buffer, calendar.getFirstDayOfWeek(), true);
        IntSerializer.put(buffer, calendar.getMinimalDaysInFirstWeek(), true);
        StringSerializer.put(buffer, this.getTimeZone(calendar).getID());
    }

    private int toInt(boolean b) {
        return b ? 1 : 0;
    }

    private boolean fromInt(int value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new IllegalArgumentException("The value " + value + " cannot be translated into a boolean value, only 0 or 1 are considered valid.");
    }

    private TimeZone getTimeZone(Calendar obj) {
        try {
            return (TimeZone)this._zoneField.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

