/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;

public class JdkProxySerializer
extends SimpleSerializer<Object> {
    private final Kryo _kryo;

    public JdkProxySerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    @Override
    public Object read(ByteBuffer buffer) {
        InvocationHandler invocationHandler = (InvocationHandler)this._kryo.readClassAndObject(buffer);
        Class[] interfaces = this._kryo.readObjectData(buffer, Class[].class);
        ClassLoader classLoader = this._kryo.getClassLoader();
        try {
            return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        }
        catch (RuntimeException e) {
            System.err.println(this.getClass().getName() + ".read:\n" + "Could not create proxy using classLoader " + classLoader + "," + " have invoctaionhandler.classloader: " + invocationHandler.getClass().getClassLoader() + " have contextclassloader: " + Thread.currentThread().getContextClassLoader());
            throw e;
        }
    }

    @Override
    public void write(ByteBuffer buffer, Object obj) {
        this._kryo.writeClassAndObject(buffer, Proxy.getInvocationHandler(obj));
        this._kryo.writeObjectData(buffer, obj.getClass().getInterfaces());
    }
}

