/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.network.impl.tcp;

import com.googlecode.mobilityrpc.common.util.IOUtil;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.impl.ConnectionErrorHandler;
import com.googlecode.mobilityrpc.network.impl.IncomingMessageHandler;
import com.googlecode.mobilityrpc.network.impl.tcp.StreamClosedException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IncomingByteStreamReader
extends Thread {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ConnectionId connectionId;
    private final InputStream inputStream;
    private final IncomingMessageHandler incomingMessageHandler;
    private final ConnectionErrorHandler connectionErrorHandler;
    private volatile boolean shutdown = false;

    public IncomingByteStreamReader(ConnectionId connectionId, InputStream inputStream, IncomingMessageHandler incomingMessageHandler, ConnectionErrorHandler connectionErrorHandler) {
        this.connectionId = connectionId;
        this.connectionErrorHandler = connectionErrorHandler;
        this.inputStream = new BufferedInputStream(inputStream, 16384);
        this.incomingMessageHandler = incomingMessageHandler;
        this.setName("IncomingByteStreamReader for " + connectionId);
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "IncomingByteStreamReader started for {0}", this.connectionId);
        while (!this.shutdown) {
            try {
                this.logger.log(Level.FINER, "Waiting for incoming messages for {0}", this.connectionId);
                byte[] messageSizeHeader = IncomingByteStreamReader.readBytesFromStream(this.inputStream, 4);
                int nextMessageSize = IncomingByteStreamReader.byteArrayToInt(messageSizeHeader);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Receiving incoming message: " + nextMessageSize + " bytes from " + this.connectionId);
                }
                byte[] messageBytes = IncomingByteStreamReader.readBytesFromStream(this.inputStream, nextMessageSize);
                this.incomingMessageHandler.receiveIncomingMessage(this.connectionId, messageBytes);
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINER, "Received and submitted for processing incoming message: " + nextMessageSize + " bytes from " + this.connectionId);
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                if (e instanceof StreamClosedException) {
                    this.connectionErrorHandler.handle(new StreamClosedException("The connection was closed by the remote side on " + this.connectionId, e));
                    continue;
                }
                this.connectionErrorHandler.handle(new IllegalStateException("Failed to receive incoming message from " + this.connectionId, e));
            }
        }
        this.shutdown = true;
        IOUtil.closeQuietly(this.inputStream);
        this.logger.log(Level.FINE, "IncomingByteStreamReader stopped for {0}", this.connectionId);
    }

    static byte[] readBytesFromStream(InputStream is, int numBytesToRead) {
        try {
            int bytesReadTotal;
            int bytesReadEachIteration;
            byte[] bytes = new byte[numBytesToRead];
            for (bytesReadTotal = 0; bytesReadTotal < numBytesToRead && (bytesReadEachIteration = is.read(bytes, bytesReadTotal, numBytesToRead - bytesReadTotal)) != -1; bytesReadTotal += bytesReadEachIteration) {
            }
            if (bytesReadTotal < numBytesToRead) {
                throw new StreamClosedException("Stream was closed explicitly by remote side, while reading byte " + bytesReadTotal + " of " + numBytesToRead);
            }
            return bytes;
        }
        catch (StreamClosedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read " + numBytesToRead + " bytes from stream", e);
        }
    }

    static int byteArrayToInt(byte[] bytes) {
        return (bytes[0] << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

