/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.serialization.impl;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.ObjectBuffer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.ReferenceFieldSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.ArraysAsListSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.ClassSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.CurrencySerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.JdkProxySerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.StringBufferSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.StringBuilderSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import com.googlecode.mobilityrpc.lib.org.objenesis.ObjenesisStd;
import com.googlecode.mobilityrpc.serialization.Serializer;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;

public class KryoSerializer
implements Serializer {
    private final ClassLoader classLoader;
    private final Kryo kryo;
    private final int INITIAL_BUFFER_SIZE_IN_BYTES = 32768;
    private final int MAX_BUFFER_SIZE_IN_BYTES = 0x6400000;
    private final int MAX_CACHEABLE_BUFFER_SIZE_IN_BYTES = 65536;
    private final ThreadLocal<ObjectBuffer> threadLocalObjectBuffers = new ThreadLocal<ObjectBuffer>(){

        @Override
        protected ObjectBuffer initialValue() {
            return new ObjectBuffer(KryoSerializer.this.kryo, 32768, 0x6400000);
        }
    };

    public KryoSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
        final ObjenesisStd objenesisStd = new ObjenesisStd();
        this.kryo = new Kryo(){

            @Override
            protected com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer newDefaultSerializer(Class aClass) {
                return new ReferenceFieldSerializer(this, aClass){
                    {
                        this.setIgnoreSyntheticFields(false);
                    }

                    @Override
                    public <T> T newInstance(Kryo kryo, Class<T> tClass) {
                        try {
                            return tClass.cast(objenesisStd.newInstance(tClass));
                        }
                        catch (Exception e) {
                            throw new SerializationException("Could not instantiate class using JVM-specific strategy: " + tClass.getName(), e);
                        }
                    }
                };
            }
        };
        this.kryo.setRegistrationOptional(true);
        this.kryo.setClassLoader(classLoader);
        this.kryo.register(Arrays.asList("").getClass(), new ArraysAsListSerializer(this.kryo));
        this.kryo.register(Class.class, new ClassSerializer(this.kryo));
        this.kryo.register(Collections.EMPTY_LIST.getClass(), new CollectionsEmptyListSerializer());
        this.kryo.register(Collections.EMPTY_MAP.getClass(), new CollectionsEmptyMapSerializer());
        this.kryo.register(Collections.EMPTY_SET.getClass(), new CollectionsEmptySetSerializer());
        this.kryo.register(Collections.singletonList("").getClass(), new CollectionsSingletonListSerializer(this.kryo));
        this.kryo.register(Collections.singleton("").getClass(), new CollectionsSingletonSetSerializer(this.kryo));
        this.kryo.register(Collections.singletonMap("", "").getClass(), new CollectionsSingletonMapSerializer(this.kryo));
        this.kryo.register(Currency.class, new CurrencySerializer(this.kryo));
        this.kryo.register(GregorianCalendar.class, new GregorianCalendarSerializer());
        this.kryo.register(InvocationHandler.class, new JdkProxySerializer(this.kryo));
        this.kryo.register(StringBuffer.class, new StringBufferSerializer(this.kryo));
        this.kryo.register(StringBuilder.class, new StringBuilderSerializer(this.kryo));
        UnmodifiableCollectionsSerializer.registerSerializers(this.kryo);
        SynchronizedCollectionsSerializer.registerSerializers(this.kryo);
    }

    @Override
    public byte[] serialize(Object object) {
        ObjectBuffer buffer = this.threadLocalObjectBuffers.get();
        byte[] result = buffer.writeClassAndObject(object);
        if (result.length > 65536) {
            this.threadLocalObjectBuffers.remove();
        }
        return result;
    }

    @Override
    public Object deserialize(byte[] serializedData) {
        ObjectBuffer buffer = this.threadLocalObjectBuffers.get();
        if (serializedData.length > 65536) {
            this.threadLocalObjectBuffers.remove();
        }
        return buffer.readClassAndObject(serializedData);
    }
}

