/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.network.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerImpl;
import com.googlecode.mobilityrpc.network.Connection;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.impl.ConnectionInternal;
import com.googlecode.mobilityrpc.network.impl.ConnectionListenerInternal;
import com.googlecode.mobilityrpc.network.impl.ConnectionManagerInternal;
import com.googlecode.mobilityrpc.network.impl.ConnectionStateListener;
import com.googlecode.mobilityrpc.network.impl.tcp.TCPConnection;
import com.googlecode.mobilityrpc.network.impl.tcp.TCPConnectionListener;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionManagerImpl
implements ConnectionManagerInternal,
ConnectionStateListener {
    private final ConcurrentMap<ConnectionId, ConnectionInternal> connections = new ConcurrentHashMap<ConnectionId, ConnectionInternal>();
    private final ConcurrentMap<ConnectionId, ConnectionListenerInternal> incomingConnectionListeners = new ConcurrentHashMap<ConnectionId, ConnectionListenerInternal>();
    private final MobilityControllerImpl mobilityController;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ConnectionManagerImpl(MobilityControllerImpl mobilityController) {
        this.mobilityController = mobilityController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(ConnectionId identifier) {
        ConnectionInternal connection = (ConnectionInternal)this.connections.get(identifier);
        if (connection == null) {
            ConcurrentMap<ConnectionId, ConnectionInternal> concurrentMap = this.connections;
            synchronized (concurrentMap) {
                connection = (ConnectionInternal)this.connections.get(identifier);
                if (connection == null) {
                    connection = this.createOutgoingConnection(identifier);
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionInternal createOutgoingConnection(ConnectionId identifier) {
        ConcurrentMap<ConnectionId, ConnectionInternal> concurrentMap = this.connections;
        synchronized (concurrentMap) {
            Socket socket;
            int auxiliaryConnectionId = identifier.getAuxiliaryConnectionId();
            if (auxiliaryConnectionId < 0) {
                throw new IllegalArgumentException("Cannot establish an outgoing connection with the auxiliary connection id specified: " + identifier);
            }
            if (auxiliaryConnectionId > 0 && !this.connections.containsKey(new ConnectionId(identifier.getAddress(), identifier.getPort(), 0))) {
                throw new IllegalStateException("Cannot establish an outgoing auxiliary connection, because the primary connection is down: " + identifier);
            }
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(identifier.getAddress(), identifier.getPort()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to establish outgoing connection to: " + identifier, e);
            }
            TCPConnection connection = new TCPConnection(socket, identifier, this.mobilityController, this);
            connection.init();
            this.notifyConnectionOpened(connection);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Created outgoing connection to: " + identifier);
            }
            return connection;
        }
    }

    @Override
    public void notifyConnectionOpened(ConnectionInternal connection) {
        ConnectionInternal existing = this.connections.putIfAbsent(connection.getConnectionId(), connection);
        if (existing != null) {
            throw new IllegalStateException("Duplicate connection detected, a connection is already registered for identifier: " + connection.getConnectionId());
        }
    }

    @Override
    public void notifyConnectionClosed(ConnectionInternal connection) {
        this.connections.remove(connection.getConnectionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionRegistered(ConnectionId connectionId) {
        ConcurrentMap<ConnectionId, ConnectionInternal> concurrentMap = this.connections;
        synchronized (concurrentMap) {
            return this.connections.containsKey(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindConnectionListener(ConnectionId localEndpointIdentifier) {
        ConcurrentMap<ConnectionId, ConnectionListenerInternal> concurrentMap = this.incomingConnectionListeners;
        synchronized (concurrentMap) {
            TCPConnectionListener newListener = new TCPConnectionListener(localEndpointIdentifier, this.mobilityController, this);
            ConnectionListenerInternal existingListener = this.incomingConnectionListeners.putIfAbsent(localEndpointIdentifier, newListener);
            if (existingListener != null) {
                throw new IllegalStateException("A listener is already registered for connection id: " + localEndpointIdentifier);
            }
            try {
                newListener.init();
            }
            catch (RuntimeException e) {
                this.incomingConnectionListeners.remove(localEndpointIdentifier);
                throw e;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Created connection listener for local endpoint: " + localEndpointIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindConnectionListener(ConnectionId localEndpointIdentifier) {
        ConcurrentMap<ConnectionId, ConnectionListenerInternal> concurrentMap = this.incomingConnectionListeners;
        synchronized (concurrentMap) {
            ConnectionListenerInternal existing = (ConnectionListenerInternal)this.incomingConnectionListeners.remove(localEndpointIdentifier);
            if (existing == null) {
                throw new IllegalStateException("No such listener is registered for connection id: " + localEndpointIdentifier);
            }
            existing.destroy();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Destroyed connection listener for local endpoint: " + localEndpointIdentifier);
            }
        }
    }

    @Override
    public Collection<ConnectionId> getConnectionListenerIdentifiers() {
        return Collections.unmodifiableSet(this.incomingConnectionListeners.keySet());
    }

    @Override
    public Collection<ConnectionId> getConnectionIds() {
        return Collections.unmodifiableSet(this.connections.keySet());
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        for (ConnectionId listenerIdentifier : this.incomingConnectionListeners.keySet()) {
            this.unbindConnectionListener(listenerIdentifier);
        }
        for (ConnectionInternal connection : this.connections.values()) {
            connection.destroy();
        }
    }
}

