/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.pojo;

import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import java.util.Arrays;
import java.util.List;

public class ResourceResponse {
    private final List<ResourceData> resourceDataResponses;
    private final RequestIdentifier requestIdentifier;

    public ResourceResponse(List<ResourceData> resourceDataResponses, RequestIdentifier requestIdentifier) {
        this.resourceDataResponses = resourceDataResponses;
        this.requestIdentifier = requestIdentifier;
    }

    public List<ResourceData> getResourceDataResponses() {
        return this.resourceDataResponses;
    }

    public RequestIdentifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceResponse that = (ResourceResponse)o;
        return this.requestIdentifier.equals(that.requestIdentifier);
    }

    public int hashCode() {
        return this.requestIdentifier.hashCode();
    }

    public String toString() {
        return "ResourceResponse{resourceDataResponses=" + this.resourceDataResponses + ", requestIdentifier=" + this.requestIdentifier + '}';
    }

    public static class ResourceData {
        private final String resourceName;
        private final byte[] resourceData;

        public ResourceData(String resourceName, byte[] resourceData) {
            this.resourceName = resourceName;
            this.resourceData = resourceData;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public byte[] getResourceData() {
            return this.resourceData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceData resourceData = (ResourceData)o;
            return this.resourceName.equals(resourceData.resourceName) && Arrays.equals(this.resourceData, resourceData.resourceData);
        }

        public int hashCode() {
            int result = this.resourceName.hashCode();
            result = 31 * result + Arrays.hashCode(this.resourceData);
            return result;
        }

        public String toString() {
            return "ResourceData{resourceName='" + this.resourceName + '\'' + ", resourceData=" + this.resourceData.length + " bytes" + '}';
        }
    }
}

