/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.session.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionClassLoader
extends ClassLoader {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final long BYTE_CODE_REQUEST_TIMEOUT_MILLIS = 10000L;
    private final MobilityControllerInternal mobilityController;
    private final UUID sessionId;
    private final ThreadLocal<ConnectionId> threadLocalConnectionIds = new ThreadLocal();
    private final ConcurrentMap<RequestIdentifier, FutureResourceResponse> futureResourceResponses = new ConcurrentHashMap<RequestIdentifier, FutureResourceResponse>();
    private final Map<String, byte[]> resourceDataCache = new ConcurrentHashMap<String, byte[]>();

    public SessionClassLoader(MobilityControllerInternal mobilityController, UUID sessionId) {
        super(SessionClassLoader.class.getClassLoader());
        this.mobilityController = mobilityController;
        this.sessionId = sessionId;
    }

    public void setThreadLocalConnectionId(ConnectionId connectionId) {
        this.threadLocalConnectionIds.set(connectionId);
    }

    public void processResourceResponse(ResourceResponse resourceResponse) {
        RequestIdentifier requestIdentifier = resourceResponse.getRequestIdentifier();
        FutureResourceResponse futureResourceResponse = (FutureResourceResponse)this.futureResourceResponses.get(requestIdentifier);
        if (futureResourceResponse == null) {
            this.logger.log(Level.FINE, "Ignored ResourceResponse, no pending request found, request must have timed out: {0}", resourceResponse);
            return;
        }
        futureResourceResponse.setResponse(resourceResponse);
        this.logger.log(Level.FINE, "Accepted ResourceResponse, passed to request thread: {0}", resourceResponse);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            ConnectionId threadLocalConnectionId = this.threadLocalConnectionIds.get();
            if (threadLocalConnectionId == null) {
                throw new ClassNotFoundException("No thread-local connection id is registered for the thread requesting class: " + name);
            }
            String resourceName = name.replace('.', '/') + ".class";
            List<String> requiredClasses = Collections.singletonList(resourceName);
            FutureResourceResponse futureResponse = this.sendResourceRequest(requiredClasses);
            ResourceResponse resourceResponse = futureResponse.getResponse(10000L, TimeUnit.MILLISECONDS);
            byte[] requiredResourceData = null;
            for (ResourceResponse.ResourceData resourceData : resourceResponse.getResourceDataResponses()) {
                if (!resourceName.equals(resourceData.getResourceName())) continue;
                requiredResourceData = resourceData.getResourceData();
                this.resourceDataCache.put(resourceName, requiredResourceData);
                break;
            }
            if (requiredResourceData == null) {
                throw new ClassNotFoundException("The remote machine could not locate bytecode for the requested class: " + name + ", resource name: " + resourceName);
            }
            return this.defineClass(name, requiredResourceData, 0, requiredResourceData.length);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Could not locate bytecode for the requested class: " + name, t);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] cachedResourceData = this.resourceDataCache.get(name);
        if (cachedResourceData != null) {
            return new ByteArrayInputStream(cachedResourceData);
        }
        return super.getResourceAsStream(name);
    }

    FutureResourceResponse sendResourceRequest(List<String> requestedResources) {
        ConnectionId threadLocalConnectionId = this.threadLocalConnectionIds.get();
        if (threadLocalConnectionId == null) {
            throw new IllegalStateException("No thread-local connection id is registered for the thread requesting classes: " + requestedResources);
        }
        UUID requestId = UUID.randomUUID();
        RequestIdentifier requestIdentifier = new RequestIdentifier(this.sessionId, requestId, "Request for resources: " + requestedResources);
        FutureResourceResponse futureResourceResponse = new FutureResourceResponse(requestIdentifier);
        this.futureResourceResponses.put(requestIdentifier, futureResourceResponse);
        ResourceRequest resourceRequest = new ResourceRequest(requestedResources, requestIdentifier);
        this.mobilityController.sendOutgoingMessage(threadLocalConnectionId, resourceRequest);
        return futureResourceResponse;
    }

    class FutureResourceResponse {
        private final RequestIdentifier requestIdentifier;
        private final BlockingQueue<ResourceResponse> responseQueue = new ArrayBlockingQueue<ResourceResponse>(1);

        FutureResourceResponse(RequestIdentifier requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        public ResourceResponse getResponse(long timeout, TimeUnit unit) {
            try {
                ResourceResponse resourceResponse = this.responseQueue.poll(timeout, unit);
                if (resourceResponse == null) {
                    throw new TimeoutException();
                }
                ResourceResponse resourceResponse2 = resourceResponse;
                return resourceResponse2;
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timed out waiting to receive class bytecode or resource within timeout of " + timeout + " " + unit.name().toLowerCase(), e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception waiting to receive bytecode or resource", e);
            }
            finally {
                SessionClassLoader.this.futureResourceResponses.remove(this.requestIdentifier);
            }
        }

        public boolean setResponse(ResourceResponse resourceResponse) {
            return this.responseQueue.add(resourceResponse);
        }
    }
}

