/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
extends Serializer {
    static final Object[] noArgs = new Object[0];
    private final Kryo kryo;
    private CachedProperty[] properties;
    Object access;

    public BeanSerializer(Kryo kryo, Class type) {
        BeanInfo info;
        this.kryo = kryo;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ex) {
            throw new SerializationException("Error getting bean info.", ex);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<CachedProperty> cachedProperties = new ArrayList<CachedProperty>(descriptors.length);
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String name = propertyDescriptor.getName();
            if (name.equals("class")) continue;
            Method getMethod = propertyDescriptor.getReadMethod();
            Method setMethod = propertyDescriptor.getWriteMethod();
            if (getMethod == null || setMethod == null) continue;
            Serializer serializer = null;
            Class<?> returnType = getMethod.getReturnType();
            if (this.isFinal(returnType)) {
                serializer = kryo.getRegisteredClass(returnType).getSerializer();
            }
            CachedProperty cachedProperty = new CachedProperty();
            cachedProperty.name = name;
            cachedProperty.getMethod = getMethod;
            cachedProperty.setMethod = setMethod;
            cachedProperty.serializer = serializer;
            cachedProperty.setMethodType = setMethod.getParameterTypes()[0];
            cachedProperties.add(cachedProperty);
        }
        this.properties = cachedProperties.toArray(new CachedProperty[cachedProperties.size()]);
        try {
            this.access = MethodAccess.get(type);
            for (CachedProperty cachedProperty : this.properties) {
                cachedProperty.getterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.getMethod.getName());
                cachedProperty.setterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.setMethod.getName());
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        Class<?> type = object.getClass();
        for (CachedProperty property : this.properties) {
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Writing property: " + property + " (" + type.getName() + ")");
                }
                Object value = property.get(object);
                Serializer serializer = property.serializer;
                if (serializer != null) {
                    serializer.writeObject(buffer, value);
                    continue;
                }
                this.kryo.writeClassAndObject(buffer, value);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing getter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (InvocationTargetException ex) {
                throw new SerializationException("Error invoking getter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote bean: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        return this.readObjectData(this.newInstance(this.kryo, type), buffer, type);
    }

    protected <T> T readObjectData(T object, ByteBuffer buffer, Class<T> type) {
        for (CachedProperty property : this.properties) {
            try {
                Serializer serializer;
                if (Log.TRACE) {
                    Log.trace("kryo", "Reading property: " + property + " (" + object.getClass() + ")");
                }
                Object value = (serializer = property.serializer) != null ? serializer.readObject(buffer, property.setMethodType) : this.kryo.readClassAndObject(buffer);
                property.set(object, value);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing setter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (InvocationTargetException ex) {
                throw new SerializationException("Error invoking setter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read bean: " + object);
        }
        return object;
    }

    class CachedProperty {
        String name;
        Method getMethod;
        Method setMethod;
        Class setMethodType;
        Serializer serializer;
        int getterAccessIndex;
        int setterAccessIndex;

        CachedProperty() {
        }

        public String toString() {
            return this.name;
        }

        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                return ((MethodAccess)BeanSerializer.this.access).invoke(object, this.getterAccessIndex, new Object[0]);
            }
            return this.getMethod.invoke(object, noArgs);
        }

        void set(Object object, Object value) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                ((MethodAccess)BeanSerializer.this.access).invoke(object, this.setterAccessIndex, value);
                return;
            }
            this.setMethod.invoke(object, value);
        }
    }
}

