/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializer
extends Serializer {
    private Object[] enumConstants;

    public EnumSerializer(Class<? extends Enum> type) {
        this.enumConstants = type.getEnumConstants();
        if (this.enumConstants == null) {
            throw new IllegalArgumentException("The type must be an enum: " + type);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        int ordinal = IntSerializer.get(buffer, true);
        if (ordinal < 0 || ordinal > this.enumConstants.length - 1) {
            throw new SerializationException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
        }
        Object constant = this.enumConstants[ordinal];
        if (Log.TRACE) {
            Log.trace("kryo", "Read enum: " + constant);
        }
        return (T)constant;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        EnumSerializer.put(buffer, (Enum)object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote enum: " + object);
        }
    }

    public static void put(ByteBuffer buffer, Enum object) {
        IntSerializer.put(buffer, object.ordinal(), true);
    }

    public static <T> T get(ByteBuffer buffer, Class<T> type) {
        T[] enumConstants = type.getEnumConstants();
        if (enumConstants == null) {
            throw new SerializationException("Class is not an enum: " + type.getName());
        }
        int ordinal = IntSerializer.get(buffer, true);
        if (ordinal < 0 || ordinal > enumConstants.length - 1) {
            throw new SerializationException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
        }
        return enumConstants[ordinal];
    }
}

