/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class IntSerializer
extends Serializer {
    private boolean optimizePositive = true;

    public IntSerializer() {
    }

    public IntSerializer(boolean optimizePositive) {
        this.optimizePositive = optimizePositive;
    }

    public Integer readObjectData(ByteBuffer buffer, Class type) {
        int i = IntSerializer.get(buffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Read int: " + i);
        }
        return i;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        IntSerializer.put(buffer, (Integer)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote int: " + object);
        }
    }

    public static int put(ByteBuffer buffer, int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if ((value & 0xFFFFFF80) == 0) {
            buffer.put((byte)value);
            return 1;
        }
        buffer.put((byte)(value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            buffer.put((byte)value);
            return 2;
        }
        buffer.put((byte)(value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            buffer.put((byte)value);
            return 3;
        }
        buffer.put((byte)(value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            buffer.put((byte)value);
            return 4;
        }
        buffer.put((byte)(value & 0x7F | 0x80));
        buffer.put((byte)(value >>>= 7));
        return 5;
    }

    public static int get(ByteBuffer buffer, boolean optimizePositive) {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            byte b = buffer.get();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            if (!optimizePositive) {
                result = result >>> 1 ^ -(result & 1);
            }
            return result;
        }
        throw new SerializationException("Malformed integer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRead(ByteBuffer buffer, boolean optimizePositive) {
        int position = buffer.position();
        try {
            int remaining = buffer.remaining();
            for (int offset = 0; offset < 32 && remaining > 0; offset += 7, --remaining) {
                if ((buffer.get() & 0x80) != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.position(position);
        }
    }

    public static int length(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            return 2;
        }
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            return 3;
        }
        if (((value >>>= 7) & 0xFFFFFF80) == 0) {
            return 4;
        }
        value >>>= 7;
        return 5;
    }
}

