/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.network.impl.tcp;

import com.googlecode.mobilityrpc.common.util.IOUtil;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.impl.ConnectionListenerInternal;
import com.googlecode.mobilityrpc.network.impl.ConnectionStateListener;
import com.googlecode.mobilityrpc.network.impl.IncomingMessageHandler;
import com.googlecode.mobilityrpc.network.impl.tcp.TCPConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPConnectionListener
implements ConnectionListenerInternal {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final IncomingMessageHandler incomingMessageHandler;
    private final ConnectionStateListener connectionStateListener;
    private final ConnectionId localEndpointIdentifier;
    private final AtomicInteger auxiliaryConnectionIdProvider = new AtomicInteger();
    private Acceptor acceptor;
    private final ExecutorService acceptorService = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public TCPConnectionListener(ConnectionId localEndpointIdentifier, IncomingMessageHandler incomingMessageHandler, ConnectionStateListener connectionStateListener) {
        this.localEndpointIdentifier = localEndpointIdentifier;
        this.incomingMessageHandler = incomingMessageHandler;
        this.connectionStateListener = connectionStateListener;
    }

    @Override
    public void init() {
        if (this.acceptor != null) {
            throw new IllegalStateException("Already initialized.");
        }
        try {
            InetAddress bindAddress = InetAddress.getByName(this.localEndpointIdentifier.getAddress());
            ServerSocket serverSocket = new ServerSocket(this.localEndpointIdentifier.getPort(), 50, bindAddress);
            Acceptor acceptor = new Acceptor(serverSocket);
            this.acceptorService.submit(acceptor);
            this.acceptor = acceptor;
            this.logger.log(Level.FINE, "Initialized connection listener for local endpoint: {0}", this.localEndpointIdentifier);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize connection listener for local endpoint: " + this.localEndpointIdentifier, e);
        }
    }

    @Override
    public void destroy() {
        Acceptor acceptor = this.acceptor;
        if (acceptor != null) {
            acceptor.stop();
        }
        this.logger.log(Level.FINE, "Destroyed connection listener for local endpoint: {0}", this.localEndpointIdentifier);
    }

    @Override
    public ConnectionId getConnectionId() {
        return this.localEndpointIdentifier;
    }

    class Acceptor
    implements Runnable {
        private final ServerSocket serverSocket;
        private volatile boolean stopSignalled = false;

        Acceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            try {
                TCPConnectionListener.this.logger.log(Level.FINE, "Connection listener started for local endpoint: {0}", TCPConnectionListener.this.localEndpointIdentifier);
                while (true) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    TCPConnectionListener.this.logger.log(Level.FINER, "Waiting for connections to local endpoint: {0}", TCPConnectionListener.this.localEndpointIdentifier);
                    Socket socket = this.serverSocket.accept();
                    int auxiliaryConnectionId = !TCPConnectionListener.this.connectionStateListener.isConnectionRegistered(new ConnectionId(socket.getInetAddress().getHostAddress(), socket.getPort(), 0)) ? 0 : TCPConnectionListener.this.auxiliaryConnectionIdProvider.decrementAndGet();
                    ConnectionId connectionId = new ConnectionId(socket.getInetAddress().getHostAddress(), socket.getPort(), auxiliaryConnectionId);
                    TCPConnection connection = new TCPConnection(socket, connectionId, TCPConnectionListener.this.incomingMessageHandler, TCPConnectionListener.this.connectionStateListener);
                    if (TCPConnectionListener.this.logger.isLoggable(Level.FINER)) {
                        TCPConnectionListener.this.logger.log(Level.FINER, "Received connection on local endpoint " + TCPConnectionListener.this.localEndpointIdentifier + " from " + connection.getConnectionId());
                    }
                    connection.init();
                    TCPConnectionListener.this.connectionStateListener.notifyConnectionOpened(connection);
                }
            }
            catch (Exception e) {
                if (this.stopSignalled) {
                    TCPConnectionListener.this.logger.log(Level.FINE, "ConnectionListener stopped for local endpoint: {0}", TCPConnectionListener.this.localEndpointIdentifier);
                } else {
                    if (TCPConnectionListener.this.logger.isLoggable(Level.WARNING)) {
                        TCPConnectionListener.this.logger.log(Level.WARNING, "ConnectionListener stopped due to exception for local endpoint: " + TCPConnectionListener.this.localEndpointIdentifier, e);
                    }
                    this.stop();
                }
                return;
            }
        }

        public void stop() {
            this.stopSignalled = true;
            IOUtil.closeQuietly(this.serverSocket);
            TCPConnectionListener.this.acceptor = null;
        }
    }
}

