/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.converters;

import com.googlecode.mobilityrpc.protocol.pojo.Envelope;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionResponse;
import com.googlecode.mobilityrpc.protocol.pojo.Ping;
import com.googlecode.mobilityrpc.protocol.pojo.Pong;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import java.util.HashMap;
import java.util.Map;

public class MessageTypeRegistry {
    private final Map<Envelope.MessageType, Class<?>> messageTypeToClass = new HashMap();
    private final Map<Class<?>, Envelope.MessageType> classToMessageType = new HashMap();

    public MessageTypeRegistry() {
        this.register(Envelope.MessageType.EXECUTION_REQUEST, ExecutionRequest.class);
        this.register(Envelope.MessageType.EXECUTION_RESPONSE, ExecutionResponse.class);
        this.register(Envelope.MessageType.RESOURCE_REQUEST, ResourceRequest.class);
        this.register(Envelope.MessageType.RESOURCE_RESPONSE, ResourceResponse.class);
        this.register(Envelope.MessageType.PING, Ping.class);
        this.register(Envelope.MessageType.PONG, Pong.class);
    }

    private void register(Envelope.MessageType messageType, Class<?> messageClass) {
        this.messageTypeToClass.put(messageType, messageClass);
        this.classToMessageType.put(messageClass, messageType);
    }

    public Class<?> getMessageClass(Envelope.MessageType messageType) {
        Class<?> result = this.messageTypeToClass.get((Object)messageType);
        if (result == null) {
            throw new IllegalStateException("No message class for message type: " + (Object)((Object)messageType));
        }
        return result;
    }

    public Envelope.MessageType getMessageType(Class<?> messageClass) {
        Envelope.MessageType result = this.classToMessageType.get(messageClass);
        if (result == null) {
            throw new IllegalStateException("No message type for message class: " + messageClass);
        }
        return result;
    }
}

