/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.network.impl.tcp;

import com.googlecode.mobilityrpc.common.util.IOUtil;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.impl.ConnectionErrorHandler;
import com.googlecode.mobilityrpc.network.impl.MessageProvider;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutgoingByteStreamWriter
extends Thread {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ConnectionId connectionId;
    private final OutputStream outputStream;
    private final MessageProvider<byte[]> outgoingMessageProvider;
    private final ConnectionErrorHandler connectionErrorHandler;
    private volatile boolean shutdown = false;

    public OutgoingByteStreamWriter(ConnectionId connectionId, OutputStream outputStream, MessageProvider<byte[]> outgoingMessageProvider, ConnectionErrorHandler connectionErrorHandler) {
        this.connectionId = connectionId;
        this.outputStream = new BufferedOutputStream(outputStream, 16384);
        this.outgoingMessageProvider = outgoingMessageProvider;
        this.connectionErrorHandler = connectionErrorHandler;
        this.setName("OutgoingByteStreamWriter for " + connectionId);
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "OutgoingByteStreamWriter started for {0}", this.connectionId);
        while (!this.shutdown) {
            try {
                this.logger.log(Level.FINER, "Waiting for outgoing messages for {0}", this.connectionId);
                byte[] nextMessage = this.outgoingMessageProvider.getNextMessage();
                int nextMessageSize = nextMessage.length;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Sending outgoing message: " + nextMessageSize + " bytes to " + this.connectionId);
                }
                this.writeNextMessageSize(this.outputStream, nextMessageSize);
                this.outputStream.write(nextMessage);
                this.outputStream.flush();
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINER, "Sent outgoing message: " + nextMessageSize + " bytes to " + this.connectionId);
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                this.connectionErrorHandler.handle(new IllegalStateException("Failed to send outgoing message to " + this.connectionId, e));
            }
        }
        this.shutdown = true;
        IOUtil.closeQuietly(this.outputStream);
        this.logger.log(Level.FINE, "OutgoingByteStreamWriter stopped for {0}", this.connectionId);
    }

    void writeNextMessageSize(OutputStream outputStream, int nextMessageSize) {
        try {
            byte[] nextMessageSizeBytes = this.intToByteArray(nextMessageSize);
            outputStream.write(nextMessageSizeBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to write 4-byte indicator of next message size", e);
        }
    }

    byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

