/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.converters.messages;

import com.google.protobuf.ByteString;
import com.googlecode.mobilityrpc.protocol.converters.MessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.components.RequestIdentifierComponentConverter;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import com.googlecode.mobilityrpc.protocol.protobuf.MessageResourceResponse;
import java.util.ArrayList;

public class ResourceResponseMessageConverter
extends MessageConverter<ResourceResponse> {
    private final RequestIdentifierComponentConverter requestIdentifierConverter = new RequestIdentifierComponentConverter();

    @Override
    protected ResourceResponse fromProtobuf(byte[] bytes) throws Exception {
        MessageResourceResponse.ResourceResponse.Builder builder = MessageResourceResponse.ResourceResponse.newBuilder();
        builder.mergeFrom(bytes);
        ArrayList<ResourceResponse.ResourceData> resourceResponses = new ArrayList<ResourceResponse.ResourceData>(builder.getResourceDataCount());
        int n = builder.getResourceDataCount();
        for (int i = 0; i < n; ++i) {
            MessageResourceResponse.ResourceData protobufResourceData = builder.getResourceData(i);
            resourceResponses.add(new ResourceResponse.ResourceData(protobufResourceData.getResourceName(), protobufResourceData.getResourceData().toByteArray()));
        }
        return new ResourceResponse(resourceResponses, this.requestIdentifierConverter.convertFromProtobuf(builder.getRequestIdentifier()));
    }

    @Override
    protected byte[] toProtobuf(ResourceResponse object) throws Exception {
        MessageResourceResponse.ResourceResponse.Builder builder = MessageResourceResponse.ResourceResponse.newBuilder();
        MessageResourceResponse.ResourceData.Builder resourceDataBuilder = MessageResourceResponse.ResourceData.newBuilder();
        for (ResourceResponse.ResourceData resourceData : object.getResourceDataResponses()) {
            resourceDataBuilder.setResourceName(resourceData.getResourceName());
            resourceDataBuilder.setResourceData(ByteString.copyFrom((byte[])resourceData.getResourceData()));
            builder.addResourceData(resourceDataBuilder);
        }
        builder.setRequestIdentifier(this.requestIdentifierConverter.convertToProtobuf(object.getRequestIdentifier()));
        return builder.build().toByteArray();
    }
}

