/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.processors.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.ConnectionManager;
import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessor;
import com.googlecode.mobilityrpc.session.MobilitySession;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceRequestMessageProcessor
implements DeserializedMessageProcessor<ResourceRequest> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void process(MobilityControllerInternal mobilityController, ConnectionManager connectionManager, ConnectionId connectionId, ResourceRequest resourceRequest) {
        byte[] resourceData;
        RequestIdentifier requestIdentifier = resourceRequest.getRequestIdentifier();
        MobilitySession session = mobilityController.getSession(requestIdentifier.getSessionId());
        if (resourceRequest.getResourceNames().size() != 1) {
            throw new IllegalStateException("Unsupported number of resources requested, expected one resource: " + resourceRequest.getResourceNames());
        }
        String requestedResourceName = resourceRequest.getResourceNames().get(0);
        try {
            resourceData = ResourceRequestMessageProcessor.getResourceFromClassLoader(requestedResourceName, session.getSessionClassLoader());
        }
        catch (ClassNotFoundException e) {
            resourceData = null;
        }
        List<ResourceResponse.ResourceData> resourceDataListToReturn = resourceData != null ? Collections.singletonList(new ResourceResponse.ResourceData(requestedResourceName, resourceData)) : Collections.emptyList();
        ResourceResponse resourceResponse = new ResourceResponse(resourceDataListToReturn, requestIdentifier);
        mobilityController.sendOutgoingMessage(connectionId, resourceResponse);
        if (this.logger.isLoggable(Level.FINER)) {
            if (resourceResponse.getResourceDataResponses().isEmpty()) {
                this.logger.log(Level.FINER, "Failed to locate class bytecode or resource '" + requestedResourceName + "', returned response: " + resourceResponse);
            } else {
                this.logger.log(Level.FINER, "Successfully located class bytecode or resource '" + requestedResourceName + "', returned response: " + resourceResponse);
            }
        }
    }

    public static byte[] getResourceFromClassLoader(String resourceName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            InputStream inputStream = classLoader.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new ClassNotFoundException("Class loader could not locate class bytecode or resource '" + resourceName + "' via class loader '" + classLoader + "'");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int value = 0;
            while (value != -1) {
                value = inputStream.read();
                if (value == -1) continue;
                byteArrayOutputStream.write(value);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load class bytecode or resource: " + resourceName + ", class loader: " + classLoader);
        }
    }
}

